/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.plugin.webfragment.conditions.UserIsProjectAdminCondition;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.AdminSummaryPanel;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebPanelModuleDescriptor;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebPanel;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class AdminSummary
extends JiraWebActionSupport {
    static final String CONTEXT_PANEL_KEY = "panelKey";
    static final String CONTEXT_TOP_PANEL_KEY = "webpanels.admin.summary.top-panels";
    static final String CONTEXT_LEFT_COLUMN_KEY = "webpanels.admin.summary.left-column";
    static final String CONTEXT_RIGHT_COLUMN_KEY = "webpanels.admin.summary.right-column";
    static final String CONTEXT_IS_ADMIN_KEY = "isAdmin";
    static final String CONTEXT_IS_SYSTEM_ADMIN_KEY = "isSystemAdmin";
    static final String CONTEXT_I18N_KEY = "i18n";
    private final WebInterfaceManager webInterfaceManager;
    private final WebResourceManager webResourceManager;
    private final JiraAuthenticationContext authenticationContext;
    private final PermissionManager permissionManager;
    private final VelocityRequestContextFactory requestContextFactory;

    public AdminSummary(WebResourceManager webResourceManager, WebInterfaceManager webInterfaceManager, JiraAuthenticationContext authenticationContext, PermissionManager permissionManager, VelocityRequestContextFactory requestContextFactory) {
        this.webResourceManager = webResourceManager;
        this.webInterfaceManager = webInterfaceManager;
        this.authenticationContext = authenticationContext;
        this.permissionManager = permissionManager;
        this.requestContextFactory = requestContextFactory;
    }

    protected String doExecute() throws Exception {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        session.removeAttribute("atl.jira.admin.current.project");
        session.removeAttribute("atl.jira.admin.current.project.tab");
        UserIsProjectAdminCondition condition = new UserIsProjectAdminCondition(this.permissionManager);
        if (!condition.shouldDisplay(this.authenticationContext.getUser(), new JiraHelper(ExecutingHttpRequest.get())) && !this.permissionManager.hasPermission(0, this.getLoggedInUser())) {
            return "permissionviolation";
        }
        this.webResourceManager.requireResource("jira.webresources:adminsummary");
        this.webResourceManager.requireResource("com.atlassian.jira.jira-admin-summary-plugin:admin-summary");
        return "input";
    }

    private Map<String, Object> getDefaultContext() {
        return MapBuilder.newBuilder().add((Object)CONTEXT_IS_ADMIN_KEY, (Object)this.hasAdminPermission()).add((Object)CONTEXT_IS_SYSTEM_ADMIN_KEY, (Object)this.hasSystemAdminPermission()).add((Object)CONTEXT_I18N_KEY, (Object)this.authenticationContext.getI18nHelper()).toMap();
    }

    public List<AdminSummaryPanel> getTopPanels() {
        return this.getPanels(CONTEXT_TOP_PANEL_KEY, this.getDefaultContext());
    }

    public List<AdminSummaryPanel> getLeftPanels() {
        return this.getPanels(CONTEXT_LEFT_COLUMN_KEY, this.getDefaultContext());
    }

    public List<AdminSummaryPanel> getRightPanels() {
        return this.getPanels(CONTEXT_RIGHT_COLUMN_KEY, this.getDefaultContext());
    }

    private List<AdminSummaryPanel> getPanels(String location, Map<String, Object> defaultPanelContext) {
        ArrayList panels = Lists.newArrayList();
        List summaryPanels = this.webInterfaceManager.getDisplayableWebPanelDescriptors(location, Collections.emptyMap());
        for (WebPanelModuleDescriptor desc : summaryPanels) {
            AdminSummaryPanel panel = this.getPanelFromDescriptor(desc, defaultPanelContext);
            panels.add(panel);
        }
        return panels;
    }

    private AdminSummaryPanel getPanelFromDescriptor(WebPanelModuleDescriptor desc, Map<String, Object> defaultPanelContext) {
        WebLabel webLabel = desc.getWebLabel();
        String name = webLabel != null ? webLabel.getDisplayableLabel(ExecutingHttpRequest.get(), defaultPanelContext) : desc.getCompleteKey();
        WebPanel webPanel = (WebPanel)desc.getModule();
        String panelDescriptorKey = desc.getKey();
        Map panelContext = MapBuilder.newBuilder(defaultPanelContext).add((Object)CONTEXT_PANEL_KEY, (Object)panelDescriptorKey).toMap();
        return new AdminSummaryPanel(name, panelDescriptorKey, webPanel.getHtml(panelContext));
    }

    private boolean hasSystemAdminPermission() {
        return this.permissionManager.hasPermission(44, this.authenticationContext.getLoggedInUser());
    }

    private boolean hasAdminPermission() {
        return this.permissionManager.hasPermission(0, this.authenticationContext.getLoggedInUser());
    }

    private int getNumberOfTabs() {
        return 0;
    }
}

