/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web;

import com.atlassian.jira.web.ExecutingHttpRequest;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import javax.servlet.http.HttpServletRequest;

@Immutable
public class HttpRequestLocal<T> {
    private final String name;

    public HttpRequestLocal(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
    }

    public T get() {
        return this.ifRequestAvailable(new RequestOperation<T>(){

            @Override
            public T run(HttpServletRequest request) {
                return request.getAttribute(HttpRequestLocal.this.name);
            }
        });
    }

    public void set(final T value) {
        this.ifRequestAvailable(new RequestOperation<Void>(){

            @Override
            public Void run(HttpServletRequest request) {
                request.setAttribute(HttpRequestLocal.this.name, value);
                return null;
            }
        });
    }

    public void remove() {
        this.ifRequestAvailable(new RequestOperation<Void>(){

            @Override
            public Void run(HttpServletRequest request) {
                request.removeAttribute(HttpRequestLocal.this.name);
                return null;
            }
        });
    }

    private <T> T ifRequestAvailable(RequestOperation<T> requestOperation) {
        HttpServletRequest request = ExecutingHttpRequest.get();
        if (request != null) {
            try {
                return requestOperation.run(request);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static interface RequestOperation<T> {
        public T run(HttpServletRequest var1);
    }
}

