/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.vcs.cvsimpl;

import alt.java.io.File;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.util.Lock;
import com.atlassian.jira.util.LockException;
import com.atlassian.jira.vcs.cvsimpl.CvsLogException;
import com.atlassian.jira.vcs.cvsimpl.CvsRepositoryUtil;
import com.atlassian.jira.vcs.cvsimpl.JiraRevisionFilter;
import com.atlassian.jira.vcs.cvsimpl.ValidationException;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.sf.statcvs.input.CvsLogBuilder;
import net.sf.statcvs.input.CvsLogfileParser;
import net.sf.statcvs.input.EmptyRepositoryException;
import net.sf.statcvs.input.LogSyntaxException;
import net.sf.statcvs.input.RepositoryFileManager;
import net.sf.statcvs.input.RevisionFilter;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.util.CvsLogUtils;
import org.apache.log4j.Logger;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.admin.AdminHandler;
import org.netbeans.lib.cvsclient.admin.StandardAdminHandler;
import org.netbeans.lib.cvsclient.command.Builder;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.log.RlogCommand;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;

public class CvsRepositoryUtilImpl
implements CvsRepositoryUtil {
    private static final Logger log = Logger.getLogger(CvsRepositoryUtilImpl.class);
    private static final String LOCK_FILE_NAME_SUFFIX = ".write.lock";
    private static final int LOCK_OBTAIN_TIMEOUT = 10000;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String KEY_CVS_REPOSITORY_ENCODING_PREFIX = "jira.cvsrepository.";
    private static final String KEY_CVS_REPOSITORY_POSTFIX = ".encoding";

    @Override
    public void checkLogFilePath(File logFile, boolean fetchLog) throws ValidationException {
        if (logFile.getRealFile() == null) {
            throw new ValidationException("Invalid path");
        }
        if (logFile.exists() && !logFile.isFile()) {
            throw new ValidationException("Please specify path to a file not a directory");
        }
        if (logFile.exists() && !logFile.canRead()) {
            throw new ValidationException("Cannot read from the specified file");
        }
        if (fetchLog && logFile.exists() && !logFile.canWrite()) {
            throw new ValidationException("Cannot read from the specified file");
        }
        File directory = logFile.getParentFile();
        if (directory == null || directory.getRealFile() == null) {
            return;
        }
        if (!directory.exists()) {
            throw new ValidationException("The directory '" + directory.getAbsolutePath() + "' of the specified log file does not exist");
        }
        if (!directory.isDirectory()) {
            throw new ValidationException("The parent path of the specified log file '" + directory.getAbsolutePath() + "' is not a directory");
        }
        if (!directory.canRead()) {
            throw new ValidationException("Cannot read the directory '" + directory.getAbsolutePath() + "' containing log file");
        }
        if (!directory.canWrite()) {
            throw new ValidationException("Cannot write to the directory '" + directory.getAbsolutePath() + "' containing log file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CvsContent parseCvsLogs(File logFile, String moduleName, String repositoryPath, String repositoryName) throws IOException, LogSyntaxException, LockException {
        log.info((Object)"Parsing log.");
        CvsLogUtils.setCountLines((boolean)false);
        Reader logReader = this.getReader(repositoryName, logFile);
        RepositoryFileManager repFileMan = new RepositoryFileManager(null);
        net.sf.statcvs.input.Builder builder = new net.sf.statcvs.input.Builder(repFileMan, null, null, null);
        builder.setRevisionFilter((RevisionFilter)new JiraRevisionFilter());
        builder.buildModule(moduleName);
        builder.setRepository(repositoryPath);
        Lock lock = this.getLock(logFile);
        try {
            if (!lock.obtain(10000L)) {
                throw new LockException("Could not obtain lock '" + lock.getLockFilePath() + "' in " + 10000 + " msecs.");
            }
        }
        catch (IOException e) {
            throw new LockException(e.getMessage(), e);
        }
        try {
            long startTime = System.currentTimeMillis();
            CvsLogUtils.setCountLines((boolean)false);
            CvsLogfileParser cvsLogfileParser = new CvsLogfileParser(logReader, (CvsLogBuilder)builder);
            cvsLogfileParser.parse();
            CvsContent cvsContent = builder.createCvsContent();
            log.info((Object)"Finished parsing log.");
            if (log.isDebugEnabled()) {
                log.debug((Object)("Parsing cvs log took " + (System.currentTimeMillis() - startTime) + "ms."));
                List commits = cvsContent.getCommits();
                if (commits != null) {
                    log.debug((Object)("Found " + commits.size() + " relevant commits."));
                } else {
                    log.debug((Object)"No relevant commits found.");
                }
            }
            CvsContent cvsContent2 = cvsContent;
            return cvsContent2;
        }
        catch (EmptyRepositoryException e) {
            if (log.isInfoEnabled()) {
                log.info((Object)("No relevant commits found in cvs log file '" + logFile.getAbsolutePath() + "'."));
            }
            CvsContent cvsContent = new CvsContent();
            return cvsContent;
        }
        finally {
            lock.release();
        }
    }

    private Reader getReader(String repositoryName, File logFile) throws FileNotFoundException, UnsupportedEncodingException {
        String encoding;
        if (repositoryName != null && (encoding = System.getProperty(KEY_CVS_REPOSITORY_ENCODING_PREFIX + repositoryName + KEY_CVS_REPOSITORY_POSTFIX)) != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found forced encoding for '" + repositoryName + "' repository - using '" + encoding + "' to read file."));
            }
            return new InputStreamReader((InputStream)new FileInputStream(logFile.getRealFile()), encoding);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Did not find a forced encoding for '" + repositoryName + "' repository - using default."));
        }
        return new InputStreamReader(new FileInputStream(logFile.getRealFile()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCvs(final File logFile, String cvsRoot, String moduleName, String password, long cvsTimeout) throws AuthenticationException, CommandException, IOException, LockException {
        long startTime;
        block32: {
            log.info((Object)"Fetching log.");
            startTime = System.currentTimeMillis();
            String workingDirectory = logFile.getParent();
            if (workingDirectory == null) {
                throw new IOException("Absolute file path not specified : \"" + logFile.getName() + "\"");
            }
            Lock lock = this.getLock(logFile);
            Connection con = null;
            boolean gotLock = false;
            try {
                con = this.openConnectionToRepository(cvsRoot, password);
                if (con != null) {
                    Boolean succeeded;
                    final Client client = new Client(con, (AdminHandler)new StandardAdminHandler());
                    client.setLocalPath(workingDirectory);
                    try {
                        gotLock = lock.obtain(10000L);
                        if (!gotLock) {
                            throw new LockException("Could not obtain lock '" + lock.getLockFilePath() + "' in " + 10000 + " msecs.");
                        }
                    }
                    catch (IOException e) {
                        throw new LockException(e.getMessage() + ". In directory " + workingDirectory, e);
                    }
                    final BufferedWriter cvsLogWriter = new BufferedWriter(new FileWriter(logFile.getRealFile()));
                    final RlogCommand rlogCommand = new RlogCommand(){

                        protected boolean assumeLocalPathWhenUnspecified() {
                            return false;
                        }
                    };
                    final LinkedList commandErrors = new LinkedList();
                    Builder fileLogBuilder = new Builder(){

                        public void parseLine(String line, boolean isErrorMessage) {
                            try {
                                if (isErrorMessage) {
                                    if (line != null && line.trim().length() > 0) {
                                        commandErrors.add(line);
                                    }
                                } else {
                                    cvsLogWriter.write(line);
                                    cvsLogWriter.write(LINE_SEPARATOR);
                                }
                            }
                            catch (IOException e) {
                                throw new CvsLogException("Error while writing the log to " + logFile.getAbsolutePath() + ".", e);
                            }
                        }

                        public void parseEnhancedMessage(String key, Object value) {
                        }

                        public void outputDone() {
                        }
                    };
                    rlogCommand.setBuilder(fileLogBuilder);
                    rlogCommand.setModule(moduleName);
                    final GlobalOptions globalOptions = new GlobalOptions();
                    globalOptions.setModeratelyQuiet(true);
                    ExecutorService executor = Executors.newSingleThreadExecutor();
                    try {
                        Future<Boolean> futureResult = executor.submit(new Callable<Boolean>(){

                            @Override
                            public Boolean call() throws Exception {
                                return client.executeCommand((Command)rlogCommand, globalOptions);
                            }
                        });
                        succeeded = futureResult.get(cvsTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException e) {
                        String message = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("admin.error.cvsmodules.operation.exceeded.timeout", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(cvsTimeout)));
                        throw new CommandException(message, message);
                    }
                    catch (TimeoutException e) {
                        String message = ComponentAccessor.getJiraAuthenticationContext().getI18nHelper().getText("admin.error.cvsmodules.operation.exceeded.timeout", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(cvsTimeout)));
                        throw new CommandException(message, message);
                    }
                    catch (ExecutionException e) {
                        Throwable targetException = e.getCause();
                        if (targetException instanceof CommandException) {
                            throw (CommandException)targetException;
                        }
                        if (targetException instanceof AuthenticationException) {
                            throw (AuthenticationException)targetException;
                        }
                        if (targetException instanceof RuntimeException) {
                            throw (RuntimeException)targetException;
                        }
                        if (targetException instanceof Error) {
                            throw (Error)targetException;
                        }
                        throw new RuntimeException("Unexepected exception from CVS client", targetException);
                    }
                    finally {
                        executor.shutdown();
                    }
                    try {
                        ((Writer)cvsLogWriter).flush();
                    }
                    catch (IOException e) {
                        log.error((Object)"Error while trying to write CVS log.", (Throwable)e);
                        throw e;
                    }
                    finally {
                        ((Writer)cvsLogWriter).close();
                    }
                    if (!commandErrors.isEmpty()) {
                        Iterator iterator = commandErrors.iterator();
                        StringBuffer result = new StringBuffer((String)iterator.next());
                        while (iterator.hasNext()) {
                            result.append(" ").append((String)iterator.next());
                        }
                        throw new CommandException(result.toString(), result.toString());
                    }
                    if (succeeded == null || !succeeded.booleanValue()) {
                        String message = "CVS rlog command failed but did not produce any errors.";
                        throw new CommandException("CVS rlog command failed but did not produce any errors.", "CVS rlog command failed but did not produce any errors.");
                    }
                    break block32;
                }
                String message = "Failed to open connection to CVS respository.";
                throw new CommandException("Failed to open connection to CVS respository.", "Failed to open connection to CVS respository.");
            }
            finally {
                if (gotLock) {
                    lock.release();
                }
                if (con != null && con.isOpen()) {
                    con.close();
                }
            }
        }
        log.info((Object)"Finished fetching log.");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cvs log took " + (System.currentTimeMillis() - startTime) + "ms."));
        }
    }

    @Override
    public Connection openConnectionToRepository(String cvsRoot, String password) throws CommandAbortedException, AuthenticationException {
        CVSRoot root = this.parseCvsRoot(cvsRoot);
        root.setPassword(password);
        Connection connection = ConnectionFactory.getConnection((CVSRoot)root);
        connection.open();
        return connection;
    }

    @Override
    public CVSRoot parseCvsRoot(String cvsRoot) {
        return CVSRoot.parse((String)cvsRoot);
    }

    @Override
    public void checkCvsRoot(String cvsRoot) throws ValidationException {
        try {
            CVSRoot root = this.parseCvsRoot(cvsRoot);
            String method = root.getMethod();
            if (!this.isValidMethod(method) && !root.isLocal()) {
                throw new ValidationException("Unsupported cvs protocol, method: " + method + " localRoot:" + root.isLocal());
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(e.getMessage(), e);
        }
    }

    private boolean isValidMethod(String method) {
        return "ext".equals(method) || "pserver".equals(method) || "local".equals(method) || "fork".equals(method);
    }

    private Lock getLock(File logfile) {
        return new Lock(logfile.getParent(), logfile.getName() + LOCK_FILE_NAME_SUFFIX);
    }
}

