/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jdk.utilities.JvmProperties;
import com.atlassian.jdk.utilities.exception.InvalidVersionException;
import com.atlassian.jdk.utilities.runtimeinformation.MemoryInformation;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.cache.HashRegistryCache;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.configurableobjects.ConfigurableObjectUtil;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationService;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationUtil;
import com.atlassian.jira.service.JiraService;
import com.atlassian.jira.service.JiraServiceContainer;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.startup.PluginComparator;
import com.atlassian.jira.upgrade.UpgradeHistoryItem;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.log.JiraLogLocator;
import com.atlassian.jira.util.system.ExtendedSystemInfoUtils;
import com.atlassian.jira.util.system.SystemInfoUtils;
import com.atlassian.jira.util.system.SystemInfoUtilsImpl;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.modzdetector.Modifications;
import com.atlassian.modzdetector.ModzRegistryException;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class ExtendedSystemInfoUtilsImpl
implements ExtendedSystemInfoUtils {
    private static final Logger log = Logger.getLogger(ExtendedSystemInfoUtilsImpl.class);
    private static final List<String> defaultProps;
    private static final List<Pattern> securityBlackListedProps;
    private static final int MILLISECONDS_IN_MINUTE = 60000;
    private final DateFormat dateFormatter = new SimpleDateFormat("EEEEE, dd MMM yyyy");
    private final DateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss Z");
    private final Properties sysProps = System.getProperties();
    private final SystemInfoUtils systemInfoUtils;
    private final ServiceManager serviceManager;
    private final PluginAccessor pluginAccessor;
    private final ApplicationProperties applicationProperties;
    private final TrustedApplicationService trustedAppService;
    private final GenericDelegator delegator;
    private final I18nHelper i18nHelper;
    private final UserUtil userUtil;
    private final HashRegistryCache registry;
    private final LocaleManager localeManager;
    private final JiraLicenseService jiraLicenseService;
    private final BuildUtilsInfo buildUtilsInfo;
    private final UpgradeManager upgradeManager;
    private final IssueIndexManager indexManager;

    protected ExtendedSystemInfoUtilsImpl(SystemInfoUtils systemInfoUtils, ServiceManager serviceManager, PluginAccessor pluginAccessor, ApplicationProperties applicationProperties, TrustedApplicationService trustedAppService, GenericDelegator delegator, I18nHelper i18nHelper, UserUtil userUtil, HashRegistryCache registry, LocaleManager localeManager, JiraLicenseService jiraLicenseService, BuildUtilsInfo buildUtilsInfo, UpgradeManager upgradeManager, IssueIndexManager indexManager) {
        this.systemInfoUtils = systemInfoUtils;
        this.serviceManager = serviceManager;
        this.pluginAccessor = pluginAccessor;
        this.applicationProperties = applicationProperties;
        this.trustedAppService = trustedAppService;
        this.delegator = delegator;
        this.i18nHelper = i18nHelper;
        this.userUtil = userUtil;
        this.registry = registry;
        this.localeManager = localeManager;
        this.indexManager = indexManager;
        this.jiraLicenseService = (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService);
        this.buildUtilsInfo = (BuildUtilsInfo)Assertions.notNull((String)"buildUtilsInfo", (Object)buildUtilsInfo);
        this.upgradeManager = (UpgradeManager)Assertions.notNull((String)"upgradeManager", (Object)upgradeManager);
    }

    public ExtendedSystemInfoUtilsImpl(I18nHelper i18nHelper) {
        this(new SystemInfoUtilsImpl(), ComponentManager.getComponentInstanceOfType(ServiceManager.class), ComponentManager.getComponentInstanceOfType(PluginAccessor.class), ComponentAccessor.getApplicationProperties(), ComponentManager.getComponentInstanceOfType(TrustedApplicationService.class), CoreFactory.getGenericDelegator(), i18nHelper, ComponentAccessor.getUserUtil(), ComponentManager.getComponentInstanceOfType(HashRegistryCache.class), ComponentManager.getComponentInstanceOfType(LocaleManager.class), ComponentManager.getComponentInstanceOfType(JiraLicenseService.class), ComponentManager.getComponentInstanceOfType(BuildUtilsInfo.class), ComponentManager.getComponentInstanceOfType(UpgradeManager.class), ComponentManager.getComponentInstanceOfType(IssueIndexManager.class));
    }

    @Override
    public SystemInfoUtils getSystemInfoUtils() {
        return this.systemInfoUtils;
    }

    @Override
    public Map<String, String> getProps() {
        return this.getProps(false);
    }

    @Override
    public Map<String, String> getProps(boolean showSensitiveInfo) {
        MapBuilder props = MapBuilder.newBuilder();
        props.add((Object)this.getText("admin.systeminfo.system.date"), (Object)this.dateFormatter.format(new Date()));
        props.add((Object)this.getText("admin.systeminfo.system.time"), (Object)this.timeFormatter.format(new Date()));
        props.add((Object)this.getText("admin.systeminfo.system.cwd"), (Object)this.sysProps.getProperty("user.dir"));
        props.add((Object)this.getText("admin.systeminfo.java.version"), (Object)this.sysProps.getProperty("java.version"));
        props.add((Object)this.getText("admin.systeminfo.java.vendor"), (Object)this.sysProps.getProperty("java.vendor"));
        props.add((Object)this.getText("admin.systeminfo.jvm.version"), (Object)this.sysProps.getProperty("java.vm.specification.version"));
        props.add((Object)this.getText("admin.systeminfo.jvm.vendor"), (Object)this.sysProps.getProperty("java.vm.specification.vendor"));
        props.add((Object)this.getText("admin.systeminfo.jvm.implementation.version"), (Object)this.sysProps.getProperty("java.vm.version"));
        props.add((Object)this.getText("admin.systeminfo.java.runtime"), (Object)this.sysProps.getProperty("java.runtime.name"));
        props.add((Object)this.getText("admin.systeminfo.java.vm"), (Object)this.sysProps.getProperty("java.vm.name"));
        props.add((Object)this.getText("admin.systeminfo.user.name"), (Object)this.sysProps.getProperty("user.name"));
        props.add((Object)this.getText("admin.systeminfo.user.timezone"), (Object)this.sysProps.getProperty("user.timezone"));
        props.add((Object)this.getText("admin.systeminfo.user.locale"), (Object)(Locale.getDefault() == null ? "null" : Locale.getDefault().getDisplayName()));
        props.add((Object)this.getText("admin.systeminfo.system.encoding"), (Object)this.sysProps.getProperty("file.encoding"));
        props.add((Object)this.getText("admin.systeminfo.operating.system"), (Object)(this.sysProps.getProperty("os.name") + " " + this.sysProps.getProperty("os.version")));
        props.add((Object)this.getText("admin.systeminfo.os.architecture"), (Object)this.sysProps.getProperty("os.arch"));
        String serverInfo = "";
        try {
            serverInfo = ActionContext.getServletContext().getServerInfo();
        }
        catch (Exception e) {
            // empty catch block
        }
        props.add((Object)this.getText("admin.systeminfo.application.server.container"), (Object)serverInfo);
        props.add((Object)this.getText("admin.systeminfo.database.type"), (Object)this.systemInfoUtils.getDatabaseType());
        props.add((Object)this.getText("admin.systeminfo.database.jndi.address"), (Object)this.systemInfoUtils.getDbDescriptorValue());
        try {
            SystemInfoUtils.DatabaseMetaData databaseMetaData = this.systemInfoUtils.getDatabaseMetaData();
            if (showSensitiveInfo) {
                props.add((Object)this.getText("admin.systeminfo.database.url"), (Object)databaseMetaData.getMaskedURL());
            } else {
                props.add((Object)this.getText("admin.systeminfo.database.url"), (Object)this.getText("admin.systeminfo.hidden.field"));
            }
            props.add((Object)this.getText("admin.systeminfo.database.version"), (Object)databaseMetaData.getDatabaseProductVersion());
            props.add((Object)this.getText("admin.systeminfo.database.driver"), (Object)(databaseMetaData.getDriverName() + " " + databaseMetaData.getDriverVersion()));
        }
        catch (Exception e) {
            props.add((Object)this.getText("admin.systeminfo.database.accesserror"), (Object)e.toString());
            log.error((Object)e, (Throwable)e);
        }
        try {
            props.add((Object)this.getText("admin.generalconfiguration.external.user.management"), (Object)(this.applicationProperties.getOption("jira.option.user.externalmanagement") ? this.getText("admin.common.words.on") : this.getText("admin.common.words.off")));
        }
        catch (Exception e) {
            log.error((Object)("Error getting the jira.option.user.externalmanagement application property: " + e), (Throwable)e);
            props.add((Object)this.getText("admin.generalconfiguration.external.user.management"), (Object)"ERROR");
        }
        if (this.isJvmJava5OrGreater()) {
            props.add((Object)this.getText("admin.systeminfo.jvm.input.arguments"), (Object)this.systemInfoUtils.getJvmInputArguments());
        } else {
            props.add((Object)this.getText("admin.systeminfo.jvm.input.arguments"), (Object)this.getText("admin.systeminfo.not.possible"));
        }
        if (showSensitiveInfo) {
            String modifiedFilesDescription = this.getText("admin.systeminfo.modz.missing");
            String removedFilesDescription = this.getText("admin.systeminfo.modz.missing");
            try {
                Modifications modifications = this.registry.getModifications();
                modifiedFilesDescription = !modifications.modifiedFiles.isEmpty() ? StringUtils.join((Collection)modifications.modifiedFiles, (String)", ") : this.getText("admin.systeminfo.modz.nomodifications");
                removedFilesDescription = !modifications.removedFiles.isEmpty() ? StringUtils.join((Collection)modifications.removedFiles, (String)", ") : this.getText("admin.systeminfo.modz.noremovals");
            }
            catch (ModzRegistryException e) {
                log.error((Object)e);
            }
            catch (RuntimeException e) {
                log.error((Object)e);
            }
            String installType = "[" + this.getText("admin.systeminfo.installation.type") + ": " + this.systemInfoUtils.getInstallationType() + "] ";
            props.add((Object)this.getText("admin.systeminfo.modz.modified"), (Object)(installType + modifiedFilesDescription));
            props.add((Object)this.getText("admin.systeminfo.modz.removed"), (Object)(installType + removedFilesDescription));
        }
        return props.toListOrderedMap();
    }

    @Override
    public Map<String, String> getApplicationPropertiesFormatted(String suffix) {
        Map properties = this.applicationProperties.asMap();
        TreeMap<String, String> props = new TreeMap<String, String>();
        for (String propertyName : properties.keySet()) {
            boolean blacklist = false;
            for (Pattern rule : securityBlackListedProps) {
                if (!rule.matcher(propertyName).matches()) continue;
                blacklist = true;
                break;
            }
            if (blacklist) continue;
            props.put(propertyName, String.valueOf(properties.get(propertyName)));
        }
        LinkedHashMap<String, String> propsMap = new LinkedHashMap<String, String>();
        propsMap.putAll(props);
        return propsMap;
    }

    @Override
    public Map<String, String> getSystemPropertiesFormatted(String suffix) {
        Enumeration<?> propNames = this.sysProps.propertyNames();
        boolean isWindows = this.sysProps.getProperty("os.name").toLowerCase(Locale.getDefault()).startsWith("windows");
        TreeMap<String, String> props = new TreeMap<String, String>();
        TreeMap<String, String> pathProps = new TreeMap<String, String>();
        while (propNames.hasMoreElements()) {
            String propertyName = (String)propNames.nextElement();
            if (defaultProps.contains(propertyName)) continue;
            if (propertyName.endsWith(".path")) {
                String htmlValue = this.sysProps.getProperty(propertyName);
                if (!isWindows) {
                    htmlValue = this.breakSeperators(htmlValue, ":", suffix);
                }
                pathProps.put(propertyName, this.breakSeperators(htmlValue, ";", suffix));
                continue;
            }
            props.put(propertyName, this.sysProps.getProperty(propertyName));
        }
        LinkedHashMap<String, String> propsMap = new LinkedHashMap<String, String>();
        propsMap.putAll(props);
        propsMap.putAll(pathProps);
        return propsMap;
    }

    @Override
    public Map<String, String> getLicenseInfo() {
        LicenseDetails licenseDetails = this.jiraLicenseService.getLicense();
        LinkedHashMap<String, String> licenseInfo = new LinkedHashMap<String, String>();
        licenseInfo.put(this.getText("admin.license.date.purchased"), licenseDetails.getPurchaseDate(this.getOutlookDate()));
        licenseInfo.put(this.getText("admin.license.type"), licenseDetails.getDescription());
        if (!licenseDetails.isUnlimitedNumberOfUsers()) {
            int userLimit = licenseDetails.getMaximumNumberOfUsers();
            licenseInfo.put(this.getText("admin.license.user.limit"), userLimit + " (" + this.getText("admin.license.active.user.count", String.valueOf(this.userUtil.getActiveUserCount())) + ")");
        }
        licenseInfo.put(this.getText("admin.license.maintenance.period.end.date"), licenseDetails.getMaintenanceEndString(this.getOutlookDate()));
        licenseInfo.put(this.getText("admin.license.maintenance.status"), licenseDetails.getBriefMaintenanceStatusMessage(this.i18nHelper));
        licenseInfo.put(this.getText("admin.license.sen"), StringUtils.isNotBlank((String)licenseDetails.getSupportEntitlementNumber()) ? licenseDetails.getSupportEntitlementNumber() : this.getText("common.concepts.not.applicable"));
        return licenseInfo;
    }

    private String breakSeperators(String input, String seperator, String suffix) {
        return input.replaceAll(seperator, seperator + suffix);
    }

    @Override
    public Map<String, String> getJvmStats() {
        MapBuilder jvmStats = MapBuilder.newBuilder();
        jvmStats.add((Object)this.getText("admin.systeminfo.total.memory"), (Object)(this.systemInfoUtils.getTotalMemory() + " MB"));
        jvmStats.add((Object)this.getText("admin.systeminfo.free.memory"), (Object)(this.systemInfoUtils.getFreeMemory() + " MB"));
        jvmStats.add((Object)this.getText("admin.systeminfo.used.memory"), (Object)(this.systemInfoUtils.getUsedMemory() + " MB"));
        jvmStats.add((Object)this.getText("admin.systeminfo.total.perm.gen.memory"), (Object)(this.systemInfoUtils.getTotalPermGenMemory() + " MB"));
        jvmStats.add((Object)this.getText("admin.systeminfo.free.perm.gen.memory"), (Object)(this.systemInfoUtils.getFreePermGenMemory() + " MB"));
        jvmStats.add((Object)this.getText("admin.systeminfo.used.perm.gen.memory"), (Object)(this.systemInfoUtils.getUsedPermGenMemory() + " MB"));
        return jvmStats.toListOrderedMap();
    }

    @Override
    public Map<String, String> getCommonConfigProperties() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put(this.getText("admin.config.allow.attachments"), String.valueOf(this.applicationProperties.getOption("jira.option.allowattachments")));
        map.put(this.getText("admin.config.allow.voting"), String.valueOf(this.applicationProperties.getOption("jira.option.voting")));
        map.put(this.getText("admin.config.allow.issue.watching"), String.valueOf(this.applicationProperties.getOption("jira.option.watching")));
        map.put(this.getText("admin.config.allow.unassigned"), String.valueOf(this.applicationProperties.getOption("jira.option.allowunassigned")));
        map.put(this.getText("admin.config.allow.subtasks"), String.valueOf(this.applicationProperties.getOption("jira.option.allowsubtasks")));
        map.put(this.getText("admin.config.allow.issue.linking"), String.valueOf(this.applicationProperties.getOption("jira.option.issuelinking")));
        map.put(this.getText("admin.config.timetracking.enabled"), String.valueOf(this.applicationProperties.getOption("jira.option.timetracking")));
        map.put(this.getText("admin.config.timetracking.hours.per.day"), this.applicationProperties.getDefaultBackedString("jira.timetracking.hours.per.day"));
        map.put(this.getText("admin.config.timetracking.days.per.week"), this.applicationProperties.getDefaultBackedString("jira.timetracking.days.per.week"));
        return map;
    }

    @Override
    public List<MemoryInformation> getMemoryPoolInformation() {
        return this.systemInfoUtils.getMemoryPoolInformation();
    }

    @Override
    public Map<String, String> getBuildStats() {
        MapBuilder buildstats = MapBuilder.newBuilder();
        buildstats.add((Object)this.getText("admin.systeminfo.uptime"), (Object)this.systemInfoUtils.getUptime(this.i18nHelper.getDefaultResourceBundle()));
        buildstats.add((Object)this.getText("admin.systeminfo.version"), (Object)this.buildUtilsInfo.getVersion());
        buildstats.add((Object)this.getText("admin.systeminfo.build.number"), (Object)this.buildUtilsInfo.getCurrentBuildNumber());
        buildstats.add((Object)this.getText("admin.systeminfo.build.date"), (Object)String.valueOf(this.buildUtilsInfo.getCurrentBuildDate()));
        buildstats.add((Object)this.getText("admin.systeminfo.build.revision"), (Object)String.valueOf(this.buildUtilsInfo.getSvnRevision()));
        buildstats.add((Object)this.getText("admin.license.partner.name"), (Object)this.buildUtilsInfo.getBuildPartnerName());
        buildstats.add((Object)this.getText("admin.systeminfo.installation.type"), (Object)this.systemInfoUtils.getInstallationType());
        buildstats.add((Object)this.getText("admin.server.id"), (Object)this.jiraLicenseService.getServerId());
        List<UpgradeHistoryItem> historyItems = this.upgradeManager.getUpgradeHistory();
        if (!historyItems.isEmpty()) {
            UpgradeHistoryItem lastUpgrade = historyItems.get(0);
            StringBuilder sb = new StringBuilder(this.getOutlookDate().formatDMYHMS(lastUpgrade.getTimePerformed()));
            if (!StringUtils.isBlank((String)lastUpgrade.getOriginalVersion()) && !StringUtils.isBlank((String)lastUpgrade.getOriginalBuildNumber())) {
                String versionPriorToUpgrade = lastUpgrade.getOriginalVersion();
                String numberPriorToUpgrade = lastUpgrade.getOriginalBuildNumber();
                sb.append(String.format(" (v%s%s%s)", versionPriorToUpgrade, "#", numberPriorToUpgrade));
            }
            buildstats.add((Object)this.getText("admin.systeminfo.last.upgrade"), (Object)sb.toString());
        }
        return buildstats.toListOrderedMap();
    }

    @Override
    public List<UpgradeHistoryItem> getUpgradeHistory() {
        return this.upgradeManager.getUpgradeHistory();
    }

    @Override
    public String getDefaultLanguage() {
        return this.applicationProperties.getDefaultLocale().getDisplayName(this.i18nHelper.getLocale());
    }

    @Override
    public String getBaseUrl() {
        return this.applicationProperties.getDefaultBackedString("jira.baseurl");
    }

    @Override
    public boolean isUsingSystemLocale() {
        return this.localeManager.getLocale(this.applicationProperties.getDefaultBackedString("jira.i18n.default.locale")) == null;
    }

    @Override
    public Map<String, String> getUsageStats() {
        MapBuilder usageStats = MapBuilder.newBuilder();
        try {
            DefaultOfBizDelegator delegator = new DefaultOfBizDelegator((DelegatorInterface)CoreFactory.getGenericDelegator());
            usageStats.add((Object)this.getText("admin.systeminfo.issues"), (Object)Long.toString(delegator.getCount("Issue")));
            usageStats.add((Object)this.getText("admin.systeminfo.projects"), (Object)Long.toString(delegator.getCount("Project")));
            usageStats.add((Object)this.getText("admin.systeminfo.custom.fields"), (Object)Long.toString(delegator.getCount("CustomField")));
            usageStats.add((Object)this.getText("admin.systeminfo.workflows"), (Object)Long.toString(delegator.getCount("Workflow")));
            usageStats.add((Object)this.getText("admin.systeminfo.attachments"), (Object)Long.toString(delegator.getCount("FileAttachment")));
            usageStats.add((Object)this.getText("admin.systeminfo.comments"), (Object)Long.toString(this.indexManager.getCommentSearcher().getIndexReader().numDocs()));
            boolean externalUserManagment = false;
            try {
                externalUserManagment = this.applicationProperties.getOption("jira.option.user.externalmanagement");
            }
            catch (Exception e) {
                log.error((Object)("Error reading jira.option.user.externalmanagement application property: " + e), (Throwable)e);
            }
            if (externalUserManagment) {
                usageStats.add((Object)this.getText("admin.systeminfo.users"), (Object)(delegator.getCount("User") + " " + this.getText("admin.generalconfiguration.external.user.management.statistics")));
                usageStats.add((Object)this.getText("admin.systeminfo.groups"), (Object)(delegator.getCount("Group") + " " + this.getText("admin.generalconfiguration.external.user.management.statistics")));
            } else {
                usageStats.add((Object)this.getText("admin.systeminfo.users"), (Object)Long.toString(delegator.getCount("User")));
                usageStats.add((Object)this.getText("admin.systeminfo.groups"), (Object)Long.toString(delegator.getCount("Group")));
            }
        }
        catch (Throwable e) {
            log.debug((Object)"Error while retrieving usage statistics", e);
            return null;
        }
        return usageStats.toListOrderedMap();
    }

    @Override
    public String getEntityEngineXmlPath() {
        try {
            return ClassLoaderUtils.getResource((String)"entityengine.xml", this.getClass()).toExternalForm();
        }
        catch (Exception e) {
            log.error((Object)("Could not load entityengine.xml path " + e.getMessage()), (Throwable)e);
            return "Could not load entityengine.xml  path.  Exception " + e.getMessage();
        }
    }

    @Override
    public String getLogPath() {
        String path;
        JiraLogLocator locator = ComponentManager.getComponentInstanceOfType(JiraLogLocator.class);
        File logFile = locator.findJiraLogFile();
        if (logFile != null) {
            path = logFile.getAbsolutePath();
        } else {
            path = "Could not find atlassian-jira.log.";
            log.debug((Object)path);
        }
        return path;
    }

    @Override
    public String getIndexLocation() {
        return ComponentAccessor.getIndexPathManager().getIndexRootPath();
    }

    @Override
    public String getAttachmentsLocation() {
        return ComponentAccessor.getAttachmentPathManager().getAttachmentPath();
    }

    @Override
    public String getBackupLocation() {
        JiraHome jiraHome = ComponentManager.getComponentInstanceOfType(JiraHome.class);
        try {
            return jiraHome.getExportDirectory().getPath();
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    @Override
    public String getJiraHomeLocation() {
        String path;
        JiraHome jiraHome = ComponentManager.getComponentInstanceOfType(JiraHome.class);
        try {
            path = jiraHome.getHomePath();
        }
        catch (IllegalStateException e) {
            path = "";
        }
        return path;
    }

    @Override
    public Collection<GenericValue> getListeners() {
        try {
            TreeSet<GenericValue> listeners = new TreeSet<GenericValue>(new Comparator<GenericValue>(){

                @Override
                public int compare(GenericValue o1, GenericValue o2) {
                    String name1 = this.getName(o1);
                    String name2 = this.getName(o2);
                    return name1.compareTo(name2);
                }

                private String getName(GenericValue o) {
                    return o.getString("name");
                }
            });
            List allListeners = this.getDelegator().findAll("ListenerConfig");
            listeners.addAll(allListeners);
            return listeners;
        }
        catch (GenericEntityException e) {
            log.error((Object)"Error retrieving listeners", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<JiraServiceContainer> getServices() {
        TreeSet<JiraServiceContainer> services = new TreeSet<JiraServiceContainer>(JiraService.NAME_COMPARATOR);
        services.addAll(this.serviceManager.getServices());
        return services;
    }

    @Override
    public Map<String, String> getServicePropertyMap(JiraServiceContainer serviceContainer) {
        try {
            return ConfigurableObjectUtil.getPropertyMap(serviceContainer);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getMillisecondsToMinutes(long ms) {
        return ms / 60000L;
    }

    @Override
    public Collection<Plugin> getPlugins() {
        TreeSet<Plugin> plugins = new TreeSet<Plugin>(new PluginComparator());
        plugins.addAll(this.pluginAccessor.getPlugins());
        return Collections.unmodifiableSet(plugins);
    }

    @Override
    public boolean isPluginEnabled(Plugin plugin) {
        return this.pluginAccessor.isPluginEnabled(plugin.getKey());
    }

    @Override
    public Set<TrustedApplicationInfo> getTrustedApplications(JiraServiceContext jiraServiceContext) {
        TreeSet<TrustedApplicationInfo> trustedApplications = new TreeSet<TrustedApplicationInfo>(TrustedApplicationService.NAME_COMPARATOR);
        trustedApplications.addAll(this.trustedAppService.getAll(jiraServiceContext));
        return trustedApplications;
    }

    @Override
    public Set<String> getIPMatches(TrustedApplicationInfo info) {
        return TrustedApplicationUtil.getLines(info.getIpMatch());
    }

    @Override
    public Set<String> getUrlMatches(TrustedApplicationInfo info) {
        return TrustedApplicationUtil.getLines(info.getUrlMatch());
    }

    @Override
    public boolean isJvmJava5OrGreater() {
        try {
            return JvmProperties.isJvmVersion((float)1.5f);
        }
        catch (InvalidVersionException e) {
            return false;
        }
    }

    private OutlookDate getOutlookDate() {
        return ManagerFactory.getOutlookDateManager().getOutlookDate(this.i18nHelper.getLocale());
    }

    private String getText(String key) {
        return this.i18nHelper.getText(key);
    }

    private String getText(String key, String value1) {
        return this.i18nHelper.getText(key, value1);
    }

    private GenericDelegator getDelegator() {
        return this.delegator;
    }

    static {
        ArrayList<String> props = new ArrayList<String>();
        props.add("user.dir");
        props.add("java.version");
        props.add("java.vendor");
        props.add("java.vm.specification.version");
        props.add("java.vm.specification.vendor");
        props.add("java.vm.version");
        props.add("java.runtime.name");
        props.add("java.vm.name");
        props.add("user.name");
        props.add("user.timezone");
        props.add("file.encoding");
        props.add("os.name");
        props.add("os.version");
        props.add("os.arch");
        defaultProps = Collections.unmodifiableList(props);
        props = new ArrayList();
        props.add("License.*");
        props.add("jira\\.sid\\.key");
        props.add("org\\.apache\\.shindig\\.common\\.crypto\\.BlobCrypter\\:key");
        props.add("applinks\\..*");
        ArrayList<Pattern> rules = new ArrayList<Pattern>();
        for (String prop : props) {
            Pattern pattern = Pattern.compile(prop);
            rules.add(pattern);
        }
        securityBlackListedProps = Collections.unmodifiableList(rules);
    }
}

