/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.dbc.Assertions;
import java.net.URI;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import org.apache.commons.lang.StringUtils;

@NotThreadSafe
public final class UrlBuilder {
    private static final char PATH_SEPARATOR = '/';
    private final StringBuilder builder;
    private final String encoding;
    private boolean hasQuery = false;

    public UrlBuilder(boolean snippet) {
        this("", snippet);
    }

    public UrlBuilder(UrlBuilder source) {
        Assertions.notNull((String)"source", (Object)source);
        this.builder = new StringBuilder(source.builder);
        this.encoding = source.encoding;
        this.hasQuery = source.hasQuery;
    }

    public UrlBuilder(String baseUrl) {
        this(baseUrl, null, false);
    }

    public UrlBuilder(String baseUrl, boolean snippet) {
        this(baseUrl, null, snippet);
    }

    public UrlBuilder(String baseUrl, String encoding, boolean snippet) {
        this.builder = new StringBuilder((String)Assertions.notNull((String)"baseUrl", (Object)baseUrl));
        this.encoding = encoding;
        this.hasQuery = snippet;
    }

    public UrlBuilder addPath(String path) {
        boolean pathStartsWithSlash;
        boolean empty = this.builder.length() == 0;
        boolean urlEndsWithSlash = !empty && this.builder.charAt(this.builder.length() - 1) == '/';
        boolean bl = pathStartsWithSlash = !path.isEmpty() && path.charAt(0) == '/';
        if (!(empty || urlEndsWithSlash || pathStartsWithSlash)) {
            this.builder.append('/');
        } else if (urlEndsWithSlash && pathStartsWithSlash) {
            path = path.substring(1);
        }
        this.builder.append(path);
        return this;
    }

    public UrlBuilder addParameterUnsafe(String name, String value) {
        Assertions.notBlank((String)"name", (String)name);
        this.addParameterSeparator();
        this.builder.append(name).append('=').append(value);
        return this;
    }

    public UrlBuilder addParameter(String name, String value) {
        Assertions.notBlank((String)"name", (String)name);
        String safeName = this.encode(name);
        String safeValue = value == null ? "" : this.encode(value);
        this.addParameterUnsafe(safeName, safeValue);
        return this;
    }

    public UrlBuilder addParameter(String name, Object value) {
        return this.addParameter(name, value == null ? null : value.toString());
    }

    public UrlBuilder addAnchor(String value) {
        Assertions.notBlank((String)"value", (String)value);
        String safeValue = this.encode(value);
        this.builder.append("#").append(safeValue);
        return this;
    }

    public UrlBuilder addParametersFromMap(Map<?, ?> params) {
        Assertions.notNull((String)"params", params);
        for (Map.Entry<?, ?> entry : params.entrySet()) {
            if (entry.getKey() == null || StringUtils.isBlank((String)entry.getKey().toString())) continue;
            this.addParameter(entry.getKey().toString(), entry.getValue());
        }
        return this;
    }

    private void addParameterSeparator() {
        if (this.hasQuery || this.builder.indexOf("?") > -1) {
            this.builder.append("&");
        } else {
            this.builder.append("?");
        }
        this.hasQuery = true;
    }

    public String asUrlString() {
        return this.builder.toString();
    }

    private String encode(String str) {
        if (str != null) {
            if (this.encoding == null) {
                return JiraUrlCodec.encode((String)str);
            }
            return JiraUrlCodec.encode((String)str, (String)this.encoding);
        }
        return str;
    }

    public URI asURI() {
        return URI.create(this.asUrlString());
    }
}

