/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.component.ProfilingComponentAdapterFactory;
import com.atlassian.jira.config.properties.ApplicationProperties;
import java.util.Collection;
import java.util.Collections;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.ComponentAdapterFactory;
import org.picocontainer.defaults.DefaultPicoContainer;

public class JiraUtils {
    public static final String AM = "am";
    public static final String PM = "pm";

    public static boolean isPublicMode() {
        ApplicationProperties ap = ComponentAccessor.getApplicationProperties();
        boolean publicMode = ap.getString("jira.mode") == null || ap.getString("jira.mode").equals("public");
        return publicMode && !JiraUtils.isExternalUserManagementEnabled();
    }

    private static boolean isExternalUserManagementEnabled() {
        ApplicationProperties applicationProperties = ComponentAccessor.getApplicationProperties();
        return applicationProperties.getOption("jira.option.user.externalmanagement");
    }

    public static <T> T loadComponent(String className, Class<?> callingClass) throws ClassNotFoundException {
        Class componentClass = ClassLoaderUtils.loadClass((String)className, callingClass);
        return JiraUtils.loadComponent(componentClass);
    }

    public static <T> T loadComponent(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class componentClass = ClassLoaderUtils.loadClass((String)className, (ClassLoader)classLoader);
        return JiraUtils.loadComponent(componentClass);
    }

    public static <T> T loadComponent(Class<T> componentClass) {
        return JiraUtils.loadComponent(componentClass, Collections.<Object>emptyList());
    }

    public static <T> T loadComponent(Class<T> componentClass, Collection<Object> extraParameters) {
        if (componentClass.isAssignableFrom(Void.class)) {
            return null;
        }
        PicoContainer applicationContainer = ComponentManager.getInstance().getContainer();
        DefaultPicoContainer tempContainer = new DefaultPicoContainer((ComponentAdapterFactory)new ProfilingComponentAdapterFactory(), applicationContainer);
        for (Object parameter : extraParameters) {
            tempContainer.registerComponentInstance(parameter);
        }
        tempContainer.registerComponentImplementation(componentClass);
        return componentClass.cast(tempContainer.getComponentInstance(componentClass));
    }

    public static int get24HourTime(String meridianIndicator, int hours) {
        if (hours == 12) {
            if (AM.equalsIgnoreCase(meridianIndicator)) {
                return 0;
            }
            if (PM.equalsIgnoreCase(meridianIndicator)) {
                return 12;
            }
        }
        int onceMeridianAdjustment = PM.equalsIgnoreCase(meridianIndicator) ? 12 : 0;
        return hours + onceMeridianAdjustment;
    }

    public static boolean isSetup() {
        return ComponentAccessor.getApplicationProperties().getString("jira.setup") != null;
    }
}

