/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.util.concurrent.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class DefaultUserManager
implements UserManager {
    private final CrowdService crowdService;
    private final CrowdDirectoryService crowdDirectoryService;
    private final ApplicationProperties applicationProperties;

    public DefaultUserManager(CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, ApplicationProperties applicationProperties) {
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.applicationProperties = applicationProperties;
    }

    public int getTotalUserCount() {
        Iterable<User> crowdUsers = this.getAllUsersFromCrowd();
        if (crowdUsers instanceof Collection) {
            return ((Collection)crowdUsers).size();
        }
        int count = 0;
        for (User crowdUser : crowdUsers) {
            ++count;
        }
        return count;
    }

    public Collection<User> getUsers() {
        Iterable<User> crowdUsers = this.getAllUsersFromCrowd();
        if (crowdUsers instanceof Collection) {
            return (Collection)crowdUsers;
        }
        LinkedList<User> users = new LinkedList<User>();
        for (User user : crowdUsers) {
            users.add(user);
        }
        return users;
    }

    private Iterable<User> getAllUsersFromCrowd() {
        UserQuery query = new UserQuery(User.class, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        return this.crowdService.search((Query)query);
    }

    public Set<User> getAllUsers() {
        HashSet<User> allUsers = new HashSet<User>();
        for (User user : this.getUsers()) {
            allUsers.add(user);
        }
        return allUsers;
    }

    private User getCrowdUser(String userName) {
        if (userName == null) {
            return null;
        }
        return this.crowdService.getUser(userName);
    }

    public User getUser(String userName) {
        return this.getUserObject(userName);
    }

    public User getUserObject(@Nullable String userName) {
        return this.getCrowdUser(userName);
    }

    public User findUserInDirectory(String userName, Long directoryId) {
        try {
            return ((DirectoryManager)ComponentAccessor.getComponentOfType(DirectoryManager.class)).findUserByName(directoryId.longValue(), userName);
        }
        catch (DirectoryNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public User getUserEvenWhenUnknown(String userName) {
        if (userName == null) {
            return null;
        }
        User user = this.getCrowdUser(userName);
        if (user == null) {
            user = new ImmutableUser.Builder().name(userName).displayName(userName).active(false).toUser();
        }
        return user;
    }

    public boolean canUpdateUser(User user) {
        if (user == null) {
            return false;
        }
        if (this.applicationProperties.getOption("jira.option.user.externalmanagement")) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    public void updateUser(User user) {
        try {
            this.crowdService.updateUser(user);
        }
        catch (InvalidUserException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
        catch (OperationNotPermittedException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    public boolean canUpdateUserPassword(User user) {
        if (!this.canUpdateUser(user)) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        return this.canDirectoryUpdateUserPassword(directory);
    }

    public boolean canUpdateGroupMembershipForUser(User user) {
        if (user == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(user.getDirectoryId());
        if (directory == null) {
            return false;
        }
        return directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    public Collection<Group> getGroups() {
        GroupQuery query = new GroupQuery(Group.class, GroupType.GROUP, (SearchRestriction)NullRestrictionImpl.INSTANCE, 0, -1);
        Iterable crowdGroups = this.crowdService.search((Query)query);
        if (crowdGroups instanceof Collection) {
            return (Collection)crowdGroups;
        }
        HashSet<Group> groups = new HashSet<Group>();
        for (Group group : crowdGroups) {
            groups.add(group);
        }
        return groups;
    }

    public Set<Group> getAllGroups() {
        return (Set)this.getGroups();
    }

    private Group getCrowdGroup(String groupName) {
        if (groupName == null) {
            return null;
        }
        return this.crowdService.getGroup(groupName);
    }

    public Group getGroup(String groupName) {
        return this.getCrowdGroup(groupName);
    }

    public Group getGroupObject(@Nullable String groupName) {
        return this.getCrowdGroup(groupName);
    }

    public List<Directory> getWritableDirectories() {
        List allDirectories = this.crowdDirectoryService.findAllDirectories();
        ArrayList<Directory> writableDirectories = new ArrayList<Directory>(allDirectories.size());
        for (Directory directory : allDirectories) {
            if (!directory.getAllowedOperations().contains(OperationType.CREATE_USER) || !directory.isActive()) continue;
            writableDirectories.add(directory);
        }
        return writableDirectories;
    }

    public boolean hasPasswordWritableDirectory() {
        List<Directory> writableDirectories = this.getWritableDirectories();
        for (Directory directory : writableDirectories) {
            if (!this.canDirectoryUpdateUserPassword(directory)) continue;
            return true;
        }
        return false;
    }

    public Directory getDirectory(Long directoryId) {
        return this.crowdDirectoryService.findDirectoryById(directoryId.longValue());
    }

    public boolean canDirectoryUpdateUserPassword(Directory directory) {
        if (directory == null) {
            return false;
        }
        return directory.getType() != DirectoryType.DELEGATING;
    }
}

