/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.profile;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.profile.UserProfileFragment;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.velocity.VelocityManager;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;

public abstract class AbstractUserProfileFragment
implements UserProfileFragment {
    private static final Logger log = Logger.getLogger(AbstractUserProfileFragment.class);
    protected final ApplicationProperties applicationProperties;
    protected final JiraAuthenticationContext jiraAuthenticationContext;
    private final VelocityManager velocityManager;

    public AbstractUserProfileFragment(ApplicationProperties applicationProperties, JiraAuthenticationContext jiraAuthenticationContext, VelocityManager velocityManager) {
        this.applicationProperties = applicationProperties;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.velocityManager = velocityManager;
    }

    @Override
    public boolean showFragment(User profileUser, User currentUser) {
        return true;
    }

    @Override
    public String getFragmentHtml(User profileUser, User currentUser) {
        String template = this.getId() + ".vm";
        try {
            Map<String, Object> velocityParams = this.createVelocityParams(profileUser, currentUser);
            String encoding = this.applicationProperties.getEncoding();
            return this.velocityManager.getEncodedBody("templates/plugins/userprofile/", template, encoding, velocityParams);
        }
        catch (VelocityException e) {
            log.error((Object)("Error occurred while rendering velocity template for 'templates/plugins/userprofile/" + template + "'."), (Throwable)e);
            return "";
        }
    }

    protected Map<String, Object> createVelocityParams(User profileUser, User currentUser) {
        Map<String, Object> velocityParams = JiraVelocityUtils.getDefaultVelocityParams(this.jiraAuthenticationContext);
        velocityParams.put("fragid", this.getId());
        velocityParams.put("profileUser", profileUser);
        velocityParams.put("currentUser", currentUser);
        velocityParams.put("i18n", this.jiraAuthenticationContext.getI18nHelper());
        return velocityParams;
    }
}

