/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.user.ExternalEntityStore;
import java.util.concurrent.ConcurrentHashMap;

public class CachingExternalEntityStore
implements ExternalEntityStore,
Startable {
    protected final ConcurrentHashMap<String, Long> nameIdMap = new ConcurrentHashMap();
    private final ExternalEntityStore delegateEntityStore;
    private final EventPublisher eventPublisher;

    public CachingExternalEntityStore(ExternalEntityStore delegateEntityStore, EventPublisher eventPublisher) {
        this.delegateEntityStore = delegateEntityStore;
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.nameIdMap.clear();
    }

    @Override
    public Long createIfDoesNotExist(String name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("ExternalEntity user name must not be null.");
        }
        Long idForName = this.nameIdMap.get(name);
        if (idForName == null) {
            idForName = this.delegateEntityStore.createIfDoesNotExist(name);
            this.nameIdMap.putIfAbsent(name, idForName);
        }
        return idForName;
    }
}

