/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks.jql;

import com.atlassian.jira.upgrade.tasks.UpgradeTask_Build604;
import com.atlassian.jira.upgrade.tasks.jql.ClauseXmlHandler;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.Clause;
import electric.xml.Element;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public abstract class AbstractCustomFieldClauseXmlHandler
implements ClauseXmlHandler {
    private static final Logger log = Logger.getLogger(AbstractCustomFieldClauseXmlHandler.class);
    private final String valueAttribbute;

    public AbstractCustomFieldClauseXmlHandler(String valueAttribbute) {
        this.valueAttribbute = Assertions.notBlank((String)"valueAttribbute", (String)valueAttribbute);
    }

    abstract Clause createClause(String var1, String var2);

    @Override
    public ClauseXmlHandler.ConversionResult convertXmlToClause(Element el) {
        String xmlFieldId = el.getName();
        String clauseName = UpgradeTask_Build604.DocumentConstantToClauseNameResolver.getClauseName(xmlFieldId);
        if (clauseName == null) {
            log.warn((Object)("Trying to generate a clause for field with id '" + xmlFieldId + "' and no corresponding clause name could be found."));
            return new ClauseXmlHandler.FailedConversionResult(xmlFieldId);
        }
        String value = el.getAttributeValue(this.valueAttribbute);
        if (StringUtils.isBlank((String)value)) {
            return new ClauseXmlHandler.FailedConversionNoValuesResult(xmlFieldId);
        }
        return new ClauseXmlHandler.FullConversionResult(this.createClause(clauseName, value));
    }

    @Override
    public boolean isSafeToNamifyValue() {
        return true;
    }
}

