/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.bean.export.IllegalXMLCharactersException;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicenseJohnsonEventRaiser;
import com.atlassian.jira.startup.JiraLauncher;
import com.atlassian.jira.startup.JiraStartupChecklist;
import com.atlassian.jira.upgrade.UpgradeManager;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ServletContextProvider;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import javax.servlet.ServletContext;
import org.apache.log4j.Logger;

public class UpgradeLauncher
implements JiraLauncher {
    private static final Logger log = Logger.getLogger(UpgradeLauncher.class);
    private static final String NO_UPGRADE_MESSAGE = "No upgrade is being performed due to detected inconsistencies.";
    private static final int V1 = 1;
    private static final String LS = System.getProperty("line.separator");

    @Override
    public void start() {
        try {
            UpgradeLauncher.checkIfUpgradeNeeded(ServletContextProvider.getServletContext());
        }
        catch (RuntimeException rte) {
            log.fatal((Object)("A RuntimeException occurred during UpgradeLauncher servlet context initialisation - " + rte.getMessage() + "."), (Throwable)rte);
            throw rte;
        }
        catch (Error error) {
            log.fatal((Object)("An Error occurred during UpgradeLauncher servlet context initialisation - " + error.getMessage() + "."), (Throwable)error);
            throw error;
        }
    }

    @Override
    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkIfUpgradeNeeded(ServletContext servletContext) {
        if (JiraStartupChecklist.startupOK()) {
            JohnsonEventContainer eventContainer = JohnsonEventContainer.get((ServletContext)servletContext);
            if (UpgradeLauncher.checkLicenseIsValid(servletContext)) {
                Event upgradingEvent = new Event(EventType.get((String)"upgrade"), "JIRA is currently being upgraded", EventLevel.get((String)"warning"));
                eventContainer.addEvent(upgradingEvent);
                try {
                    Collection<String> errors;
                    UpgradeManager manager = ManagerFactory.getUpgradeManager();
                    File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                    try {
                        errors = manager.doUpgradeIfNeededAndAllowed(tempDir.getAbsolutePath());
                    }
                    catch (IllegalXMLCharactersException ie) {
                        log.error((Object)"Illegal XML characters detected while exporting before upgrade.");
                        Event errorEvent = new Event(EventType.get((String)"export-illegal-xml"), "Illegal XML characters in data prevent successful export before the upgrade.", ie.getMessage(), EventLevel.get((String)"error"));
                        eventContainer.addEvent(errorEvent);
                        eventContainer.removeEvent(upgradingEvent);
                        return;
                    }
                    UpgradeLauncher.addEventsForErrors(eventContainer, errors);
                }
                catch (Throwable e) {
                    log.error((Object)("Exception whilst trying to upgrade: " + e.getMessage()), e);
                    Event errorEvent = new Event(EventType.get((String)"upgrade"), "An error occurred performing JIRA upgrade", e.getMessage(), EventLevel.get((String)"error"));
                    eventContainer.addEvent(errorEvent);
                }
                finally {
                    eventContainer.removeEvent(upgradingEvent);
                }
            } else {
                log.error((Object)UpgradeLauncher.constructErrorMessage(eventContainer));
            }
        } else {
            log.fatal((Object)"Skipping, JIRA is locked.");
        }
    }

    private static boolean checkLicenseIsValid(ServletContext servletContext) {
        boolean invalid = false;
        JiraLicenseService licenseService = UpgradeLauncher.getJiraLicenseService();
        LicenseDetails licenseDetails = licenseService.getLicense();
        if (licenseDetails.isLicenseSet()) {
            LicenseJohnsonEventRaiser licenseJohnsonEventRaiser = UpgradeLauncher.getLicenseJohnsonEventRaiser();
            invalid |= licenseJohnsonEventRaiser.checkLicenseIsTooOldForBuild(servletContext, licenseDetails);
            invalid |= licenseJohnsonEventRaiser.checkLicenseIsInvalid(servletContext, licenseDetails);
        }
        return !invalid;
    }

    private static void addEventsForErrors(JohnsonEventContainer cont, Collection<String> errors) {
        for (String exception : errors) {
            Event errorEvent = new Event(EventType.get((String)"upgrade"), "An error occurred performing JIRA upgrade", exception, EventLevel.get((String)"error"));
            if (cont == null) continue;
            cont.addEvent(errorEvent);
        }
    }

    private static String constructErrorMessage(JohnsonEventContainer cont) {
        StringBuffer errMsg = new StringBuffer(NO_UPGRADE_MESSAGE).append(" ");
        JiraLicenseService licenseService = UpgradeLauncher.getJiraLicenseService();
        JiraLicenseService.ValidationResult validationResult = licenseService.validate(UpgradeLauncher.getI18nHelper(), licenseService.getLicense().getLicenseString());
        if (validationResult.getLicenseVersion() == 1) {
            BuildUtilsInfo buildUtilsInfo = UpgradeLauncher.getBuildUtilsInfo();
            ExternalLinkUtil externalLinkUtil = UpgradeLauncher.getExternalLinkUtil();
            String serverId = licenseService.getServerId();
            String upgradeLink = externalLinkUtil.getProperty("external.link.jira.upgrade.lic", Arrays.asList(buildUtilsInfo.getVersion(), buildUtilsInfo.getCurrentBuildNumber(), "enterprise", serverId, String.valueOf(validationResult.getTotalUserCount()), String.valueOf(validationResult.getActiveUserCount())));
            String evaluationLink = externalLinkUtil.getProperty("external.link.jira.license.view", Arrays.asList(buildUtilsInfo.getVersion(), buildUtilsInfo.getCurrentBuildNumber(), "enterprise", serverId));
            errMsg.append(LS).append(LS).append("The current version of your license (v1) is incompatible with JIRA ").append(buildUtilsInfo.getVersion()).append(".").append(LS).append("You will need to upgrade your license or generate an evaluation license.").append(LS).append(LS).append("To upgrade your license visit : ").append(upgradeLink).append(LS).append("To generate an evaluation license visit : ").append(evaluationLink).append(LS).append(LS).append("Please follow the instructions that JIRA is presenting in your web browser.").append(LS);
        } else {
            for (Object element : cont.getEvents()) {
                Event errEvent = (Event)element;
                errMsg.append(errEvent.getDesc()).append(LS);
            }
        }
        return errMsg.toString();
    }

    private static JiraLicenseService getJiraLicenseService() {
        return ComponentManager.getComponentInstanceOfType(JiraLicenseService.class);
    }

    private static I18nHelper getI18nHelper() {
        return ComponentManager.getComponentInstanceOfType(I18nHelper.BeanFactory.class).getInstance(Locale.getDefault());
    }

    private static LicenseJohnsonEventRaiser getLicenseJohnsonEventRaiser() {
        return ComponentManager.getComponentInstanceOfType(LicenseJohnsonEventRaiser.class);
    }

    private static BuildUtilsInfo getBuildUtilsInfo() {
        return ComponentManager.getComponentInstanceOfType(BuildUtilsInfo.class);
    }

    private static ExternalLinkUtil getExternalLinkUtil() {
        return ComponentManager.getComponentInstanceOfType(ExternalLinkUtil.class);
    }
}

