/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.transaction;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.TransactionRuntimeException;
import com.atlassian.jira.transaction.TransactionSupport;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericTransactionException;

public class TransactionSupportImpl
implements TransactionSupport {
    private static final Transaction NO_OP = new Transaction(){

        @Override
        public void commit() {
        }

        @Override
        public void rollback() {
        }

        @Override
        public void finallyRollbackIfNotCommitted() throws TransactionRuntimeException {
        }

        @Override
        public boolean isNewTransaction() {
            return false;
        }
    };
    private final ApplicationProperties applicationProperties;
    private static final Logger log = Logger.getLogger(TransactionSupportImpl.class);

    public TransactionSupportImpl(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    @Override
    public Transaction begin() throws TransactionRuntimeException {
        if (this.startedTransaction(false)) {
            return new TransactionImpl();
        }
        return NO_OP;
    }

    private boolean startedTransaction(boolean forceTxn) throws TransactionRuntimeException {
        if (!forceTxn && this.applicationProperties.getOption("jira.db.txns.disabled")) {
            return false;
        }
        return this.beginTxn();
    }

    boolean beginTxn() throws TransactionRuntimeException {
        try {
            return CoreTransactionUtil.begin();
        }
        catch (GenericTransactionException e) {
            throw new TransactionRuntimeException(e);
        }
    }

    private static class TransactionImpl
    implements Transaction {
        private boolean committed = false;

        private TransactionImpl() {
        }

        @Override
        public void commit() throws TransactionRuntimeException {
            try {
                CoreTransactionUtil.commit(true);
                this.committed = true;
            }
            catch (GenericTransactionException e) {
                log.error((Object)("Unable to commit transaction : " + e.getMessage()));
                throw new TransactionRuntimeException(e);
            }
        }

        @Override
        public void rollback() throws TransactionRuntimeException {
            if (this.committed) {
                throw new IllegalStateException("The transaction has already been committed and hence you cannot rollback");
            }
            try {
                CoreTransactionUtil.rollback(true);
            }
            catch (GenericTransactionException e) {
                log.error((Object)("Unable to rollback transaction : " + e.getMessage()));
                throw new TransactionRuntimeException(e);
            }
        }

        @Override
        public void finallyRollbackIfNotCommitted() {
            if (!this.committed) {
                try {
                    this.rollback();
                }
                catch (TransactionRuntimeException transactionRuntimeException) {
                    // empty catch block
                }
            }
        }

        @Override
        public boolean isNewTransaction() {
            return true;
        }
    }
}

