/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.trackback;

import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.trackback.Trackback;
import com.atlassian.trackback.TrackbackHelper;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class TrackbackMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(TrackbackMailQueueItem.class);
    private final TrackbackHelper helper;
    private final Trackback trackback;
    private final String content;
    private final List urllinks;

    public TrackbackMailQueueItem(TrackbackHelper helper, Trackback trackback, List urlLinks) {
        this.helper = helper;
        this.trackback = trackback;
        this.urllinks = urlLinks;
        this.content = null;
    }

    public TrackbackMailQueueItem(TrackbackHelper helper, Trackback trackback, String content) {
        super("Trackback ping analysis for " + trackback.getTitle());
        this.helper = helper;
        this.trackback = trackback;
        this.urllinks = null;
        this.content = content;
    }

    public void send() throws MailException {
        this.incrementSendCount();
        if (!Boolean.getBoolean("jira.trackback.senddisabled")) {
            try {
                if (this.urllinks != null) {
                    this.helper.pingTrackbacksInContent(this.urllinks, this.trackback);
                } else if (this.content != null) {
                    this.helper.pingTrackbacksInContent(this.content, this.trackback);
                }
            }
            catch (IOException e) {
                log.error((Object)"Could not process trackbacks", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "Trackback ping " + this.trackback;
    }
}

