/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.trackback;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.trackback.TrackbackManager;
import com.atlassian.trackback.Trackback;
import com.atlassian.trackback.TrackbackException;
import com.atlassian.trackback.TrackbackStore;
import javax.servlet.http.HttpServletRequest;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class OfbizTrackbackStore
implements TrackbackStore {
    public void storeTrackback(Trackback tb, HttpServletRequest request) throws TrackbackException {
        if (!this.getApplicationProperties().getOption("jira.option.trackback.receive")) {
            throw new TrackbackException("Trackback receive disabled");
        }
        String issueKey = request.getPathInfo().substring(1);
        try {
            GenericValue aboutIssue = this.getIssueManager().getIssue(issueKey);
            if (aboutIssue == null) {
                throw new TrackbackException("Could not find issue '" + issueKey + "'");
            }
            this.getTrackbackManager().storeTrackback(tb, aboutIssue);
        }
        catch (GenericEntityException e) {
            throw new TrackbackException(tb, (Exception)((Object)e));
        }
    }

    protected IssueManager getIssueManager() {
        return ComponentManager.getComponent(IssueManager.class);
    }

    protected ApplicationProperties getApplicationProperties() {
        return ComponentManager.getComponent(ApplicationProperties.class);
    }

    protected TrackbackManager getTrackbackManager() {
        return ComponentManager.getComponent(TrackbackManager.class);
    }
}

