/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.timezone;

import com.atlassian.jira.timezone.TimeZoneInfo;
import com.atlassian.jira.util.I18nHelper;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class TimeZoneInfoImpl
implements TimeZoneInfo {
    private final String timeZoneId;
    private final String displayName;
    private final TimeZone timeZone;
    private final I18nHelper i18nHelper;
    private final String regionKey;

    public TimeZoneInfoImpl(String timeZoneId, String displayName, TimeZone timeZone, I18nHelper i18nHelper, String regionKey) {
        this.timeZoneId = timeZoneId;
        this.displayName = displayName;
        this.timeZone = timeZone;
        this.i18nHelper = i18nHelper;
        this.regionKey = regionKey;
    }

    public String getTimeZoneId() {
        return this.timeZoneId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getGMTOffset() {
        return this.formatGMTOffset(this.timeZone);
    }

    private String formatGMTOffset(TimeZone timeZone) {
        int rawOffset = timeZone.getRawOffset();
        String prefix = "+";
        if (rawOffset < 0) {
            prefix = "-";
        }
        rawOffset = rawOffset < 0 ? rawOffset * -1 : rawOffset;
        long hours = TimeUnit.HOURS.convert(rawOffset, TimeUnit.MILLISECONDS);
        long remainingOffset = (long)rawOffset - TimeUnit.MILLISECONDS.convert(hours, TimeUnit.HOURS);
        long minutes = TimeUnit.MINUTES.convert(remainingOffset, TimeUnit.MILLISECONDS);
        return String.format("(GMT%s%02d:%02d)", prefix, hours, minutes);
    }

    public String getCity() {
        String zoneLabel = this.timeZone.getID();
        zoneLabel = zoneLabel.replaceAll("/", ".");
        return this.i18nHelper.getText("timezone.zone." + zoneLabel.toLowerCase());
    }

    public String getRegionKey() {
        return this.regionKey;
    }

    public TimeZone toTimeZone() {
        return this.timeZone;
    }

    public int compareTo(TimeZoneInfo timeZoneInfo) {
        int rawOffset = timeZoneInfo.toTimeZone().getRawOffset();
        if (this.timeZone.getRawOffset() < rawOffset) {
            return -1;
        }
        if (this.timeZone.getRawOffset() > rawOffset) {
            return 1;
        }
        return this.getCity().compareTo(timeZoneInfo.getCity());
    }
}

