/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.task;

import com.atlassian.jira.task.AlreadyExecutingException;
import com.atlassian.jira.task.ImportTaskManager;
import com.atlassian.jira.task.ProvidesTaskProgress;
import com.atlassian.jira.task.RequiresTaskInformation;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskDescriptorImpl;
import com.atlassian.jira.task.TaskProgressAdapter;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.thread.JiraThreadLocalUtils;
import com.atlassian.multitenant.juc.MultiTenantExecutors;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class ImportTaskManagerImpl
implements ImportTaskManager {
    private static final Logger log = Logger.getLogger(ImportTaskManagerImpl.class);
    private final AtomicReference<TaskDescriptorImpl<?>> currentTask = new AtomicReference();
    private final ExecutorService executorService = MultiTenantExecutors.wrap((ExecutorService)Executors.newSingleThreadExecutor(new TaskManagerThreadFactory()));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> TaskDescriptor<V> submitTask(@NotNull Callable<V> callable, String taskName) throws RejectedExecutionException, AlreadyExecutingException {
        Assertions.notNull((String)"callable", callable);
        TaskProgressAdapter taskProgressAdapter = null;
        if (callable instanceof ProvidesTaskProgress) {
            taskProgressAdapter = new TaskProgressAdapter();
        }
        TaskDescriptorImpl taskDescriptor = new TaskDescriptorImpl(1L, taskName, new NoOpTaskContext(), null, taskProgressAdapter);
        FutureTask futureTask = new FutureTask(new TaskCallableDecorator(callable, taskDescriptor));
        taskDescriptor.setFuture(futureTask);
        if (callable instanceof ProvidesTaskProgress) {
            taskProgressAdapter.setTaskDescriptor(taskDescriptor);
            ((ProvidesTaskProgress)((Object)callable)).setTaskProgressSink(taskProgressAdapter);
        }
        if (callable instanceof RequiresTaskInformation) {
            RequiresTaskInformation requiresTaskInformation = (RequiresTaskInformation)((Object)callable);
            requiresTaskInformation.setTaskDescriptor(taskDescriptor);
        }
        ImportTaskManagerImpl importTaskManagerImpl = this;
        synchronized (importTaskManagerImpl) {
            if (this.currentTask.get() != null) {
                throw new AlreadyExecutingException(this.currentTask.get(), "A task with this context has already been submitted");
            }
            this.currentTask.set(taskDescriptor);
        }
        this.executorService.submit(futureTask);
        return new TaskDescriptorImpl(taskDescriptor);
    }

    @Override
    public void shutdownNow() {
        this.executorService.shutdownNow();
    }

    @Override
    public <V> TaskDescriptor<V> getTask() {
        return ImportTaskManagerImpl.copy(this.currentTask.get());
    }

    private static <V> TaskDescriptor<V> copy(TaskDescriptorImpl<V> input) {
        if (input == null) {
            return null;
        }
        return new TaskDescriptorImpl<V>(input);
    }

    static class NoOpTaskContext
    implements TaskContext {
        NoOpTaskContext() {
        }

        @Override
        public String buildProgressURL(Long taskId) {
            return "";
        }
    }

    private static class TaskManagerThreadFactory
    implements ThreadFactory {
        private final AtomicLong threadId = new AtomicLong(0L);

        private TaskManagerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, "JiraImportTaskExecutionThread-" + this.threadId.incrementAndGet());
            t.setDaemon(true);
            return t;
        }
    }

    private static class TaskCallableDecorator<V>
    implements Callable<V> {
        private final AtomicReference<Callable<V>> actualCallableRef;
        private final TaskDescriptorImpl<V> taskDescriptor;

        private TaskCallableDecorator(Callable<V> callable, TaskDescriptorImpl<V> taskDescriptor) {
            Assertions.notNull((String)"callable", callable);
            Assertions.notNull((String)"taskDescriptor", taskDescriptor);
            this.actualCallableRef = new AtomicReference<Callable<Callable<V>>>(callable);
            this.taskDescriptor = taskDescriptor;
        }

        @Override
        public V call() throws Exception {
            this.preCallSetup();
            this.taskDescriptor.setStartedTimestamp();
            try {
                Callable actualCallable = this.actualCallableRef.getAndSet(null);
                if (actualCallable != null) {
                    Object v = actualCallable.call();
                    return v;
                }
                throw new IllegalStateException("Callable executed twice.");
            }
            finally {
                this.postCallTearDown();
            }
        }

        private void preCallSetup() {
            JiraThreadLocalUtils.preCall();
        }

        private void postCallTearDown() {
            this.taskDescriptor.setFinishedTimestamp();
            JiraThreadLocalUtils.postCall(log, new JiraThreadLocalUtils.ProblemDeterminationCallback(){

                @Override
                public void onOpenTransaction() {
                    log.error((Object)("The task '" + TaskCallableDecorator.this.taskDescriptor.getDescription() + "' has left an open database transaction in play."));
                }
            });
        }
    }
}

