/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing;

import com.atlassian.jira.sharing.ShareManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.SharePermissionImpl;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.sharing.type.ProjectShareType;
import com.atlassian.jira.util.dbc.Assertions;

public class SharePermissionDeleteUtils {
    private final ShareManager shareManager;

    public SharePermissionDeleteUtils(ShareManager shareManager) {
        this.shareManager = shareManager;
    }

    public void deleteGroupPermissions(String groupName) {
        Assertions.notNull((String)"groupName", (Object)groupName);
        SharePermissionImpl permission = new SharePermissionImpl(GroupShareType.TYPE, groupName, null);
        this.shareManager.deleteSharePermissionsLike((SharePermission)permission);
    }

    public void deleteRoleSharePermissions(Long roleId) {
        Assertions.notNull((String)"roleId", (Object)roleId);
        SharePermissionImpl permission = new SharePermissionImpl(ProjectShareType.TYPE, roleId.toString());
        this.shareManager.deleteSharePermissionsLike((SharePermission)permission);
    }

    public void deleteProjectSharePermissions(Long projectId) {
        Assertions.notNull((String)"projectId", (Object)projectId);
        SharePermissionImpl permission = new SharePermissionImpl(ProjectShareType.TYPE, projectId.toString(), null);
        this.shareManager.deleteSharePermissionsLike((SharePermission)permission);
    }
}

