/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.AbstractMessageHandler;
import com.atlassian.jira.service.util.handler.CreateIssueHandler;
import com.atlassian.jira.service.util.handler.FullCommentHandler;
import com.atlassian.jira.service.util.handler.NonQuotedCommentHandler;
import com.atlassian.mail.MailUtils;
import java.io.IOException;
import java.util.Map;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.ofbiz.core.entity.GenericValue;

public class CreateOrCommentHandler
extends AbstractMessageHandler {
    public String projectKey;
    public String issueType;
    public String stripquotes;
    public static final String KEY_PROJECT = "project";
    public static final String KEY_ISSUETYPE = "issuetype";
    public static final String KEY_QUOTES = "stripquotes";
    private static final String FALSE = "false";

    public void init(Map params) {
        this.log.debug((Object)("CreateOrCommentHandler.init(params: " + params + ")"));
        super.init(params);
        if (params.containsKey(KEY_PROJECT)) {
            this.projectKey = (String)params.get(KEY_PROJECT);
        }
        if (params.containsKey(KEY_ISSUETYPE)) {
            this.issueType = (String)params.get(KEY_ISSUETYPE);
        }
        if (params.containsKey(KEY_QUOTES)) {
            this.stripquotes = (String)params.get(KEY_QUOTES);
        }
    }

    public boolean handleMessage(Message message) throws MessagingException {
        GenericValue issue;
        String subject = message.getSubject();
        if (!this.canHandleMessage(message)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Cannot handle message '" + subject + "'."));
            }
            return this.deleteEmail;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Looking for Issue Key in subject '" + subject + "'."));
        }
        if ((issue = ServiceUtils.findIssueInString((String)subject)) == null) {
            this.log.debug((Object)("Issue Key not found in subject '" + subject + "'. Inspecting the in-reply-to message ID."));
            issue = this.getAssociatedIssue(message);
        }
        if (issue != null) {
            boolean doDelete;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Issue '" + issue.getString("key") + "' found for email '" + subject + "'."));
            }
            if (this.stripquotes == null || FALSE.equalsIgnoreCase(this.stripquotes)) {
                FullCommentHandler fc = new FullCommentHandler();
                fc.setErrorHandler(this.getErrorHandler());
                fc.init(this.params);
                doDelete = fc.handleMessage(message);
            } else {
                NonQuotedCommentHandler nq = new NonQuotedCommentHandler();
                nq.setErrorHandler(this.getErrorHandler());
                nq.init(this.params);
                doDelete = nq.handleMessage(message);
            }
            return doDelete;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("No Issue found for email '" + subject + "' - creating a new Issue."));
        }
        CreateIssueHandler createIssueHandler = new CreateIssueHandler();
        createIssueHandler.setErrorHandler(this.getErrorHandler());
        createIssueHandler.init(this.params);
        return createIssueHandler.handleMessage(message);
    }

    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return !MailUtils.isContentEmpty((Part)part);
    }

    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return false;
    }
}

