/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.util.handler;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.service.util.ServiceUtils;
import com.atlassian.jira.service.util.handler.AbstractMessageHandler;
import com.atlassian.mail.MailUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class CVSLogHandler
extends AbstractMessageHandler {
    private static final Logger log = Logger.getLogger(CVSLogHandler.class);
    private static final String COMMENT_START_LINE = "Log Message:";
    private static final String COMMENT_END_LINE_1 = "Index:";
    private static final String COMMENT_END_LINE_2 = "===================================================================";
    private static final String COMMENT_2_END_LINE = "--- NEW FILE:";
    private static final String COMMENT_3_END_LINE = "DELETED ---";

    public boolean handleMessage(Message message) throws MessagingException {
        if (!this.canHandleMessage(message)) {
            return this.deleteEmail;
        }
        String messageBody = MailUtils.getBody((Message)message);
        String commentArea = this.getCommentArea(messageBody);
        User reporter = this.getReporter(message);
        if (reporter == null) {
            log.warn((Object)"The mail 'FROM' does not match a valid user");
            log.warn((Object)("This user is not in jira so can not add a comment: " + message.getFrom()[0]));
            return false;
        }
        GenericValue[] issues = ServiceUtils.findIssuesInString((String)commentArea);
        if (issues != null && issues.length > 0) {
            CommentManager commentManager = this.getCommentManager();
            IssueFactory issueFactory = ComponentManager.getComponentInstanceOfType(IssueFactory.class);
            for (int i = 0; i < issues.length; ++i) {
                try {
                    GenericValue issueGV = issues[i];
                    if (this.hasUserPermissionToComment(issueGV, reporter)) {
                        String commentBody = this.createCommentBody(message.getSubject(), commentArea);
                        MutableIssue issue = issueFactory.getIssue(issueGV);
                        commentManager.create((Issue)issue, reporter.getName(), commentBody, null, null, true);
                    } else {
                        log.warn((Object)("You (" + reporter.getDisplayName() + ") do not have permission to comment on an issue in project: " + issueGV.getLong("project")));
                    }
                    this.recordMessageId("ISSUE_COMMENTED_FROM_EMAIL", message, issueGV.getLong("id"));
                    continue;
                }
                catch (RuntimeException e) {
                    log.warn((Object)("Exception creating comment " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return true;
    }

    private String createCommentBody(String subject, String commentArea) {
        StringBuffer commentBody = new StringBuffer(32);
        commentBody.append("CVS COMMIT LOG: \n");
        if (subject != null) {
            commentBody.append("SUBJECT: ").append(subject).append("\n");
        }
        commentBody.append(commentArea);
        return commentBody.toString();
    }

    protected CommentManager getCommentManager() {
        return ComponentManager.getComponentInstanceOfType(CommentManager.class);
    }

    protected boolean hasUserPermissionToComment(GenericValue issue, User reporter) {
        return ManagerFactory.getPermissionManager().hasPermission(15, issue, reporter);
    }

    public String getCommentArea(String messageBody) {
        if (messageBody == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new StringReader(messageBody));
        boolean insideComment = false;
        StringBuffer comment = new StringBuffer();
        try {
            String line = reader.readLine();
            while (line != null) {
                if (!insideComment) {
                    if (line.toLowerCase().startsWith(COMMENT_START_LINE.toLowerCase())) {
                        insideComment = true;
                    }
                } else {
                    if (line.startsWith(COMMENT_2_END_LINE) || line.endsWith(COMMENT_3_END_LINE) || line.endsWith(COMMENT_END_LINE_2)) {
                        insideComment = false;
                        return comment.toString();
                    }
                    if (line.startsWith(COMMENT_END_LINE_1)) {
                        String line2 = reader.readLine();
                        if (line2 != null) {
                            if (line2.startsWith(COMMENT_END_LINE_2)) {
                                insideComment = false;
                                return comment.toString();
                            }
                            comment.append(line);
                            comment.append("\n");
                            comment.append(line2);
                            comment.append("\n");
                        }
                    } else {
                        comment.append(line);
                        comment.append("\n");
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            log.warn((Object)("IOException reading Mail body: " + e.getMessage()), (Throwable)e);
        }
        if (insideComment) {
            log.warn((Object)("UnClosed Comment Tag!  Not adding comment: [" + comment.substring(0, 15) + "]"));
        }
        return null;
    }

    protected boolean attachPlainTextParts(Part part) throws MessagingException, IOException {
        return false;
    }

    protected boolean attachHtmlParts(Part part) throws MessagingException, IOException {
        return false;
    }
}

