/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.imap;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.service.services.mail.MailFetcherService;

public class ImapService
extends MailFetcherService {
    public static final String FOLDER_NAME_KEY = "foldername";

    public String getProtocol(boolean useSSL) {
        if (useSSL) {
            return "imaps";
        }
        return "imap";
    }

    protected String getFolderName() {
        try {
            if (this.getProperty(FOLDER_NAME_KEY) != null) {
                return this.getProperty(FOLDER_NAME_KEY);
            }
            return "INBOX";
        }
        catch (ObjectConfigurationException e) {
            throw new DataAccessException("Error retrieving foldername.", (Throwable)e);
        }
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("IMAPSERVICE", "services/com/atlassian/jira/service/services/imap/imapservice.xml", null);
    }
}

