/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.service.services.file;

import com.atlassian.configurable.ObjectConfiguration;
import com.atlassian.configurable.ObjectConfigurationException;
import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.service.services.file.AbstractMessageHandlingService;
import com.atlassian.jira.util.PathUtils;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;

public class FileService
extends AbstractMessageHandlingService {
    private static final Logger log = Logger.getLogger(FileService.class);
    private static final String KEY_DIRECTORY = "directory";
    private File directory = null;
    public static final String MAIL_DIR = PathUtils.joinPaths((String[])new String[]{"import", "mail"});
    public static final String KEY_SUBDIRECTORY = "subdirectory";

    public void init(PropertySet props) throws ObjectConfigurationException {
        super.init(props);
        String dir = "";
        if (this.hasProperty(KEY_DIRECTORY)) {
            dir = this.getProperty(KEY_DIRECTORY);
        }
        if (StringUtils.isNotBlank((String)dir)) {
            this.directory = new File(dir);
        } else if (this.hasProperty(KEY_SUBDIRECTORY) && StringUtils.isNotBlank((String)this.getProperty(KEY_SUBDIRECTORY))) {
            try {
                this.directory = new File(this.getJiraHome().getHome(), PathUtils.joinPaths((String[])new String[]{MAIL_DIR, this.getProperty(KEY_SUBDIRECTORY)})).getCanonicalFile();
            }
            catch (IOException e) {
                throw new ObjectConfigurationException((Throwable)e);
            }
        } else {
            this.directory = new File(this.getJiraHome().getHome(), MAIL_DIR);
        }
        if (!this.directory.isDirectory()) {
            log.warn((Object)("Directory: " + dir + " setup for FileService is not a directory."));
        } else if (!this.directory.canRead()) {
            log.warn((Object)("Directory: " + dir + " setup for FileService does not allow read."));
        } else if (!this.directory.canWrite()) {
            log.warn((Object)("Directory: " + dir + " setup for FileService does not allow write."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this.directory == null) {
            log.warn((Object)"Directory is not set for FileService");
            return;
        }
        if (!this.directory.exists()) {
            log.warn((Object)("Directory " + this.directory.getPath() + " does not exist"));
            return;
        }
        log.debug((Object)("Getting files in directory: " + this.directory));
        File[] files = this.directory.listFiles();
        if (files == null) {
            log.warn((Object)("List of files retrieved from " + this.directory + " was null?"));
        } else {
            for (File file : files) {
                if (!file.isFile() || !file.canRead() || !file.canWrite()) continue;
                log.debug((Object)("Trying to parse file: " + file.getAbsolutePath()));
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(file);
                    MimeMessage message = new MimeMessage(null, (InputStream)fis);
                    boolean delete = this.getHandler().handleMessage((Message)message);
                    fis.close();
                    fis = null;
                    if (!delete) continue;
                    log.info((Object)("Deleting file: " + file.getAbsolutePath()));
                    if (!file.delete()) {
                        log.warn((Object)("Unable to delete file '" + file + "'."));
                        continue;
                    }
                    log.info((Object)("Deleted file: " + file.getAbsolutePath()));
                }
                catch (FileNotFoundException e) {
                    log.error((Object)"File not found when it should be, are two FileServices running?", (Throwable)e);
                }
                catch (MessagingException e) {
                    log.error((Object)("Messaging exception: " + (Object)((Object)e)), (Throwable)e);
                }
                catch (Throwable t) {
                    log.error((Object)("Throwable: " + t), t);
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
        }
    }

    public ObjectConfiguration getObjectConfiguration() throws ObjectConfigurationException {
        return this.getObjectConfiguration("FILESERVICE", "services/com/atlassian/jira/service/services/file/fileservice.xml", null);
    }

    JiraHome getJiraHome() {
        return ComponentManager.getComponentInstanceOfType(JiraHome.class);
    }
}

