/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.auth.trustedapps.CurrentApplicationFactory;
import com.atlassian.jira.security.auth.trustedapps.KeyFactory;
import com.atlassian.jira.util.NotNull;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.security.auth.trustedapps.CurrentApplication;
import com.atlassian.security.auth.trustedapps.DefaultCurrentApplication;
import com.atlassian.util.concurrent.LazyReference;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Random;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class DefaultCurrentApplicationFactory
implements CurrentApplicationFactory {
    private final LazyReference<CurrentApplication> currentApplicationRef;

    public DefaultCurrentApplicationFactory(final @NotNull ApplicationProperties applicationProperties, final @NotNull JiraLicenseService jiraLicenseService) {
        this.currentApplicationRef = new LazyReference<CurrentApplication>(){

            protected CurrentApplication create() throws Exception {
                return DefaultCurrentApplicationFactory.getOrCreateCurrentApplication((ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties), (JiraLicenseService)Assertions.notNull((String)"jiraLicenseService", (Object)jiraLicenseService));
            }
        };
    }

    @Override
    public CurrentApplication getCurrentApplication() {
        return (CurrentApplication)this.currentApplicationRef.get();
    }

    private static DefaultCurrentApplication getOrCreateCurrentApplication(ApplicationProperties applicationProperties, JiraLicenseService jiraLicenseService) {
        PublicKey publicKey;
        PrivateKey privateKey;
        String privateKeyData = applicationProperties.getText("jira.trustedapp.key.private.data");
        String publicKeyData = applicationProperties.getText("jira.trustedapp.key.public.data");
        if (StringUtils.isBlank((String)privateKeyData)) {
            KeyPair keyPair = DefaultCurrentApplicationFactory.generateNewKeyPair();
            privateKey = keyPair.getPrivate();
            publicKey = keyPair.getPublic();
            applicationProperties.setText("jira.trustedapp.key.private.data", KeyFactory.encode(privateKey));
            applicationProperties.setText("jira.trustedapp.key.public.data", KeyFactory.encode(publicKey));
        } else {
            privateKey = KeyFactory.getPrivateKey(privateKeyData);
            publicKey = KeyFactory.getPublicKey(publicKeyData);
        }
        String uid = applicationProperties.getString("jira.trustedapp.uid");
        if (StringUtils.isBlank((String)uid)) {
            uid = new UIDGenerator().generateUID(jiraLicenseService);
            applicationProperties.setString("jira.trustedapp.uid", uid);
        }
        return new DefaultCurrentApplication(KeyFactory.getEncryptionProvider(), publicKey, privateKey, uid);
    }

    private static KeyPair generateNewKeyPair() {
        try {
            return KeyFactory.getEncryptionProvider().generateNewKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    private static class UIDGenerator {
        final Random random = new Random();

        private UIDGenerator() {
        }

        String generateUID(JiraLicenseService jiraLicenseService) {
            String serverId = jiraLicenseService.getServerId();
            serverId = serverId != null ? serverId : String.valueOf(this.random.nextLong());
            byte[] idHash = ArrayUtils.subarray((byte[])DigestUtils.md5((String)serverId), (int)0, (int)3);
            return "jira:" + new BigInteger(1, idHash).intValue();
        }
    }

    static final class Keys {
        static final String PRIVATE_KEY_DATA = "jira.trustedapp.key.private.data";
        static final String PUBLIC_KEY_DATA = "jira.trustedapp.key.public.data";
        static final String UID = "jira.trustedapp.uid";

        Keys() {
        }
    }
}

