/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.trustedapps;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationInfo;
import com.atlassian.jira.security.auth.trustedapps.TrustedApplicationManager;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class CachingTrustedApplicationManager
implements TrustedApplicationManager,
Startable {
    private final TrustedApplicationManager delegate;
    private final EventPublisher eventPublisher;
    private final ResettableLazyReference<Cache> cache = new ResettableLazyReference<Cache>(){

        protected Cache create() {
            return new Cache(CachingTrustedApplicationManager.this.delegate.getAll());
        }
    };

    public CachingTrustedApplicationManager(TrustedApplicationManager delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.cache.reset();
    }

    @Override
    public Set<TrustedApplicationInfo> getAll() {
        return ((Cache)this.cache.get()).getAll();
    }

    @Override
    public TrustedApplicationInfo get(String applicationId) {
        return ((Cache)this.cache.get()).get(applicationId);
    }

    @Override
    public TrustedApplicationInfo get(long id) {
        return ((Cache)this.cache.get()).get(id);
    }

    @Override
    public boolean delete(User user, long id) {
        boolean result = this.delegate.delete(user, id);
        this.cache.reset();
        return result;
    }

    @Override
    public boolean delete(User user, String applicationId) {
        boolean result = this.delegate.delete(user, applicationId);
        this.cache.reset();
        return result;
    }

    @Override
    public TrustedApplicationInfo store(User user, TrustedApplicationInfo info) {
        TrustedApplicationInfo result = this.delegate.store(user, info);
        this.cache.reset();
        return result;
    }

    private static final class Cache {
        final Map<Long, TrustedApplicationInfo> byId;
        final Map<String, TrustedApplicationInfo> byAppId;

        Cache(Set<TrustedApplicationInfo> infos) {
            HashMap<Long, TrustedApplicationInfo> byId = new HashMap<Long, TrustedApplicationInfo>(infos.size());
            HashMap<String, TrustedApplicationInfo> byAppId = new HashMap<String, TrustedApplicationInfo>(infos.size());
            for (TrustedApplicationInfo info : infos) {
                byId.put(new Long(info.getNumericId()), info);
                byAppId.put(info.getID(), info);
            }
            this.byId = Collections.unmodifiableMap(byId);
            this.byAppId = Collections.unmodifiableMap(byAppId);
        }

        TrustedApplicationInfo get(long id) {
            return this.byId.get(new Long(id));
        }

        TrustedApplicationInfo get(String applicationId) {
            return this.byAppId.get(applicationId);
        }

        Set<TrustedApplicationInfo> getAll() {
            return ImmutableSet.copyOf(this.byId.values());
        }
    }
}

