/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.rememberme;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.RealClock;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.seraph.service.rememberme.DefaultRememberMeToken;
import com.atlassian.seraph.service.rememberme.RememberMeToken;
import com.atlassian.seraph.spi.rememberme.RememberMeConfiguration;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class JiraRememberMeTokenDao
implements RememberMeTokenDao {
    private static final Logger log = Logger.getLogger(JiraRememberMeTokenDao.class);
    public static final String TABLE = "RememberMeToken";
    private final OfBizDelegator delegator;
    private final RememberMeConfiguration rememberMeConfiguration;
    private final Clock clock;

    public JiraRememberMeTokenDao(OfBizDelegator delegator, RememberMeConfiguration rememberMeConfiguration) {
        this(delegator, rememberMeConfiguration, RealClock.getInstance());
    }

    public JiraRememberMeTokenDao(OfBizDelegator delegator, RememberMeConfiguration rememberMeConfiguration, Clock clock) {
        this.delegator = delegator;
        this.rememberMeConfiguration = rememberMeConfiguration;
        this.clock = clock;
    }

    public long countAll() {
        return this.delegator.getCount(TABLE);
    }

    public RememberMeToken findById(Long tokenId) {
        return this.releaseToken(this.delegator.findByPrimaryKey(TABLE, tokenId));
    }

    public List<RememberMeToken> findForUserName(String userName) {
        Map andMap = MapBuilder.newBuilder((Object)"username", (Object)userName).toMap();
        List gvs = this.delegator.findByAnd(TABLE, andMap);
        ArrayList<RememberMeToken> tokens = new ArrayList<RememberMeToken>(gvs.size());
        for (GenericValue gv : gvs) {
            RememberMeToken token = this.releaseToken(gv);
            if (token == null) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public RememberMeToken save(RememberMeToken token) {
        Timestamp now = new Timestamp(this.clock.getCurrentDate().getTime());
        Map values = MapBuilder.newBuilder((Object)"token", (Object)token.getRandomString()).add((Object)"username", (Object)token.getUserName()).add((Object)"created", (Object)now).toMap();
        GenericValue gv = this.delegator.createValue(TABLE, values);
        return this.releaseToken(gv);
    }

    public void remove(Long tokenId) {
        GenericValue gv = this.delegator.findByPrimaryKey(TABLE, tokenId);
        if (gv != null) {
            this.delegator.removeValue(gv);
        }
    }

    public void removeAllForUser(String username) {
        Map andMap = MapBuilder.newBuilder((Object)"username", (Object)username).toMap();
        this.delegator.removeByAnd(TABLE, andMap);
    }

    public void removeAll() {
        this.delegator.removeByAnd(TABLE, Collections.emptyMap());
    }

    private RememberMeToken releaseToken(GenericValue gv) {
        if (gv != null) {
            if (!this.hasExpired(gv)) {
                long createdTime = gv.getTimestamp("created").getTime();
                return DefaultRememberMeToken.builder((Long)gv.getLong("id"), (String)gv.getString("token")).setUserName(gv.getString("username")).setCreatedTime(createdTime).build();
            }
            this.delegator.removeValue(gv);
        }
        return null;
    }

    private boolean hasExpired(GenericValue gv) {
        long now;
        long maxAgeMS = this.rememberMeConfiguration.getCookieMaxAgeInSeconds() * 1000;
        Timestamp createdTS = gv.getTimestamp("created");
        if (createdTS == null) {
            return true;
        }
        long howOld = createdTS.getTime() + maxAgeMS;
        return howOld < (now = this.clock.getCurrentDate().getTime());
    }

    public static final class Columns {
        public static final String ID = "id";
        public static final String CREATED = "created";
        public static final String TOKEN = "token";
        public static final String USERNAME = "username";
    }
}

