/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.scheme.distiller;

import com.atlassian.jira.scheme.Scheme;
import com.atlassian.jira.scheme.SchemeComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DistilledSchemeResult {
    private String type;
    private List originalSchemes;
    private Map schemeToProjects;
    private Scheme resultingScheme;
    private String resultingSchemeTempName;
    private boolean selected;

    public DistilledSchemeResult(String type, Collection originalSchemes, Map schemeToProjects, Scheme resultingScheme) {
        this.type = type;
        this.originalSchemes = new ArrayList(originalSchemes);
        Collections.sort(this.originalSchemes, new SchemeComparator());
        this.schemeToProjects = schemeToProjects;
        this.resultingScheme = resultingScheme;
        this.selected = false;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getResultingSchemeTempName() {
        return this.resultingSchemeTempName;
    }

    public void setResultingSchemeTempName(String resultingSchemeTempName) {
        this.resultingSchemeTempName = resultingSchemeTempName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Collection getOriginalSchemes() {
        return this.originalSchemes;
    }

    public void setOriginalSchemes(Collection originalSchemes) {
        this.originalSchemes = new ArrayList(originalSchemes);
        Collections.sort(this.originalSchemes, new SchemeComparator());
    }

    public Collection getAssociatedProjectsForScheme(Scheme scheme) {
        Collection associatedProjects = (Collection)this.schemeToProjects.get(scheme);
        if (associatedProjects == null) {
            associatedProjects = Collections.EMPTY_LIST;
        }
        return associatedProjects;
    }

    public Set getAllAssociatedProjects() {
        HashSet allProjects = new HashSet();
        for (Scheme scheme : this.schemeToProjects.keySet()) {
            allProjects.addAll((Collection)this.schemeToProjects.get(scheme));
        }
        return allProjects;
    }

    public Scheme getResultingScheme() {
        return this.resultingScheme;
    }

    public void setResultingScheme(Scheme resultingScheme) {
        this.resultingScheme = resultingScheme;
    }
}

