/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.association.NodeAssociationStore;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.comparator.OfBizComparators;
import com.atlassian.jira.ofbiz.DefaultOfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectImpl;
import com.atlassian.util.profiling.UtilTimerStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericValue;

public class ProjectCache {
    private static final Logger log = Logger.getLogger(ProjectCache.class);
    private static final Comparator<GenericValue> PROJECT_NAME_COMPARATOR = OfBizComparators.NAME_COMPARATOR;
    private final OfBizDelegator delegator = new DefaultOfBizDelegator((DelegatorInterface)CoreFactory.getGenericDelegator());
    private volatile Map<Long, GenericValue> projectsById;
    private volatile Map<String, GenericValue> projectsByKey;
    private volatile Map<Long, GenericValue> projectCategories;
    private volatile Map<String, Long> projectToProjectCategories;
    private volatile Map<GenericValue, List<Long>> projectCategoriesToProjects;
    private volatile List<Long> projectsWithNoCategory;
    private volatile List<Project> allProjectObjects;

    public ProjectCache(boolean refresh) {
        if (refresh) {
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refresh() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ProjectCache.refresh");
        }
        long start = System.currentTimeMillis();
        UtilTimerStack.push((String)"ProjectCache.refresh");
        try {
            this.refreshProjectList();
            this.refreshProjectCategories();
            this.refreshCategoryProjectMappings();
            this.refreshProjectsWithNoCategory();
        }
        finally {
            UtilTimerStack.pop((String)"ProjectCache.refresh");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("ProjectCache.refresh took " + (System.currentTimeMillis() - start)));
        }
    }

    private void refreshProjectList() {
        List dbProjects = this.delegator.findAll("Project");
        Collections.sort(dbProjects, PROJECT_NAME_COMPARATOR);
        LinkedHashMap<Long, GenericValue> tmpById = new LinkedHashMap<Long, GenericValue>();
        LinkedHashMap<String, GenericValue> tmpByKey = new LinkedHashMap<String, GenericValue>();
        ArrayList<ProjectImpl> tmpAllProjects = new ArrayList<ProjectImpl>(dbProjects.size());
        for (GenericValue projectGV : dbProjects) {
            tmpById.put(projectGV.getLong("id"), projectGV);
            tmpByKey.put(projectGV.getString("key"), projectGV);
            tmpAllProjects.add(new ProjectImpl(projectGV));
        }
        this.projectsById = Collections.unmodifiableMap(tmpById);
        this.projectsByKey = Collections.unmodifiableMap(tmpByKey);
        this.allProjectObjects = Collections.unmodifiableList(tmpAllProjects);
    }

    protected void refreshProjectCategories() {
        List dbCategories = this.delegator.findAll("ProjectCategory");
        Collections.sort(dbCategories, PROJECT_NAME_COMPARATOR);
        LinkedHashMap<Long, GenericValue> tmpById = new LinkedHashMap<Long, GenericValue>();
        for (GenericValue projectCategory : dbCategories) {
            tmpById.put(projectCategory.getLong("id"), projectCategory);
        }
        this.projectCategories = Collections.unmodifiableMap(tmpById);
    }

    public GenericValue getProject(Long id) {
        return this.projectsById.get(id);
    }

    public GenericValue getProjectByName(String name) {
        for (GenericValue project : this.getProjects()) {
            if (!project.getString("name").equalsIgnoreCase(name)) continue;
            return project;
        }
        return null;
    }

    public GenericValue getProjectByKey(String key) {
        return this.projectsByKey.get(key);
    }

    public Collection<GenericValue> getProjects() {
        return this.projectsById.values();
    }

    public List<Project> getProjectObjects() {
        return this.allProjectObjects;
    }

    public Collection<GenericValue> getProjectCategories() {
        return this.projectCategories.values();
    }

    public GenericValue getProjectCategory(Long id) {
        return this.projectCategories.get(id);
    }

    private void refreshCategoryProjectMappings() {
        HashMap<String, Long> tmpProjectToProjectCategories = new HashMap<String, Long>();
        HashMap<GenericValue, List<Long>> tmpProjectCategoriesToProjects = new HashMap<GenericValue, List<Long>>();
        Collection<GenericValue> categories = this.getProjectCategories();
        if (categories != null) {
            for (GenericValue category : categories) {
                try {
                    List<GenericValue> projects = ((NodeAssociationStore)ComponentAccessor.getComponentOfType(NodeAssociationStore.class)).getSourcesFromSink(category, "Project", "ProjectCategory");
                    Collections.sort(projects, PROJECT_NAME_COMPARATOR);
                    tmpProjectCategoriesToProjects.put(category, this.getIdsFromGenericValues(projects));
                    for (GenericValue project : projects) {
                        tmpProjectToProjectCategories.put(project.getString("key"), category.getLong("id"));
                    }
                }
                catch (DataAccessException ex) {
                    log.error((Object)("Error getting projects for category " + category + ": " + (Object)((Object)ex)), (Throwable)ex);
                }
            }
        }
        this.projectToProjectCategories = Collections.unmodifiableMap(tmpProjectToProjectCategories);
        this.projectCategoriesToProjects = Collections.unmodifiableMap(tmpProjectCategoriesToProjects);
    }

    private List<Long> getIdsFromGenericValues(Collection<GenericValue> genericValues) {
        if (genericValues == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<GenericValue> projectIds = new ArrayList<GenericValue>(genericValues);
        CollectionUtils.transform(projectIds, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ((GenericValue)object).getLong("id");
            }
        });
        return projectIds;
    }

    private List getProjectsFromProjectIds(Collection projectIds) {
        if (projectIds == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList projects = new ArrayList(projectIds);
        CollectionUtils.transform(projects, (Transformer)new Transformer(){

            public Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ProjectCache.this.getProject((Long)object);
            }
        });
        return projects;
    }

    public Collection getProjectsFromProjectCategory(GenericValue projectCat) {
        if (this.projectCategoriesToProjects.containsKey(projectCat)) {
            return this.getProjectsFromProjectIds(this.projectCategoriesToProjects.get(projectCat));
        }
        return Collections.EMPTY_LIST;
    }

    public GenericValue getProjectCategoryForProject(Project project) {
        if (project != null && this.projectToProjectCategories.containsKey(project.getKey())) {
            Long projectCategoryId = this.projectToProjectCategories.get(project.getKey());
            return this.getProjectCategory(projectCategoryId);
        }
        return null;
    }

    public GenericValue getProjectCategoryFromProject(GenericValue project) {
        if (project != null && this.projectToProjectCategories.containsKey(project.getString("key"))) {
            Long projectId = this.projectToProjectCategories.get(project.getString("key"));
            return this.getProjectCategory(projectId);
        }
        return null;
    }

    public Collection getProjectsWithNoCategory() {
        return this.getProjectsFromProjectIds(this.projectsWithNoCategory);
    }

    protected void refreshProjectsWithNoCategory() {
        this.projectsWithNoCategory = new ArrayList<Long>();
        ArrayList<GenericValue> projectsWithNoCategoryGVs = new ArrayList<GenericValue>();
        for (GenericValue project : this.getProjects()) {
            if (this.getProjectCategoryFromProject(project) != null) continue;
            projectsWithNoCategoryGVs.add(project);
        }
        Collections.sort(projectsWithNoCategoryGVs, PROJECT_NAME_COMPARATOR);
        this.projectsWithNoCategory = Collections.unmodifiableList(this.getIdsFromGenericValues(projectsWithNoCategoryGVs));
    }
}

