/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.comparator.IssueStatusComparator;
import com.atlassian.jira.issue.status.Status;
import com.atlassian.jira.plugin.workflow.AbstractWorkflowPluginFactory;
import com.atlassian.jira.plugin.workflow.WorkflowPluginConditionFactory;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;

public class WorkflowSubTaskBlockingConditionFactoryImpl
extends AbstractWorkflowPluginFactory
implements WorkflowPluginConditionFactory {
    private final ConstantsManager constantsManager;
    private static final String STATUS_ID_PARAM_KEY = "issue_statuses";

    public WorkflowSubTaskBlockingConditionFactoryImpl(ConstantsManager constantsManager) {
        this.constantsManager = constantsManager;
    }

    protected void getVelocityParamsForInput(Map velocityParams) {
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        Collection statuses = constantsManager.getStatuses();
        velocityParams.put("statuses", Collections.unmodifiableCollection(statuses));
    }

    protected void getVelocityParamsForEdit(Map velocityParams, AbstractDescriptor descriptor) {
        this.getVelocityParamsForInput(velocityParams);
        velocityParams.put("selectedStatuses", this.getSelectedStatusIds(descriptor));
    }

    protected void getVelocityParamsForView(Map velocityParams, AbstractDescriptor descriptor) {
        Collection selectedStatusIds = this.getSelectedStatusIds(descriptor);
        LinkedList<Status> selectedStatuses = new LinkedList<Status>();
        for (String statusId : selectedStatusIds) {
            selectedStatuses.add(this.constantsManager.getStatusObject(statusId));
        }
        Collections.sort(selectedStatuses, new IssueStatusComparator());
        velocityParams.put("statuses", Collections.unmodifiableCollection(selectedStatuses));
    }

    public Map getDescriptorParams(Map conditionParams) {
        String[] statusIds = (String[])conditionParams.get(STATUS_ID_PARAM_KEY);
        if (statusIds != null) {
            StringBuffer statIds = new StringBuffer();
            for (int i = 0; i < statusIds.length; ++i) {
                String statusId = statusIds[i];
                statIds.append(statusId).append(",");
            }
            return EasyMap.build((Object)"statuses", (Object)statIds.substring(0, statIds.length() - 1));
        }
        throw new IllegalArgumentException("Please select at least one status.");
    }

    private Collection getSelectedStatusIds(AbstractDescriptor descriptor) {
        LinkedList<String> selectedStatusIds = new LinkedList<String>();
        if (!(descriptor instanceof ConditionDescriptor)) {
            throw new IllegalArgumentException("Descriptor must be a ConditionDescriptor.");
        }
        ConditionDescriptor conditionDescriptor = (ConditionDescriptor)descriptor;
        String statuses = (String)conditionDescriptor.getArgs().get("statuses");
        StringTokenizer st = new StringTokenizer(statuses, ",");
        while (st.hasMoreTokens()) {
            selectedStatusIds.add(st.nextToken());
        }
        return selectedStatusIds;
    }
}

