/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManagerImpl;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import org.apache.log4j.Logger;

public class JiraWebResourceManagerImpl
extends WebResourceManagerImpl {
    private static final Logger log = Logger.getLogger(JiraWebResourceManagerImpl.class);
    private String staticBaseUrl;

    public JiraWebResourceManagerImpl(ApplicationProperties appProps, PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        super(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, batchingConfiguration);
        String cdn = appProps.getDefaultBackedString("jira.cdn.static.prefix");
        if (cdn != null) {
            if (cdn.endsWith("/")) {
                cdn = cdn.substring(0, cdn.length() - 1);
            }
            log.info((Object)("CDN static prefix in use, prefix=" + cdn));
        }
        this.staticBaseUrl = cdn;
    }

    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        if (this.staticBaseUrl != null) {
            return this.staticBaseUrl + super.getStaticResourcePrefix(resourceCounter, UrlMode.RELATIVE);
        }
        return super.getStaticResourcePrefix(resourceCounter, urlMode);
    }

    public String getStaticResourcePrefix(UrlMode urlMode) {
        if (this.staticBaseUrl != null) {
            return this.staticBaseUrl + super.getStaticResourcePrefix(UrlMode.RELATIVE);
        }
        return super.getStaticResourcePrefix(urlMode);
    }
}

