/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webresource;

import com.atlassian.jira.config.properties.JiraSystemProperties;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import java.util.ArrayList;
import java.util.List;

public class JiraWebResourceBatchingConfiguration
implements ResourceBatchingConfiguration {
    private static final boolean DEV_MODE = JiraSystemProperties.isDevMode();
    private static final boolean SUPER_BATCHING_DISABLED = JiraSystemProperties.isSuperBatchingDisabled();
    private static final String WEB_RESOURCE_BATCHING_OFF = System.getProperty("plugin.webresource.batching.off");
    private static final List<String> resources = new ArrayList<String>();

    public boolean isSuperBatchingEnabled() {
        return !resources.isEmpty() && !SUPER_BATCHING_DISABLED;
    }

    public boolean isContextBatchingEnabled() {
        return !DEV_MODE;
    }

    public boolean isPluginWebResourceBatchingEnabled() {
        if (WEB_RESOURCE_BATCHING_OFF != null) {
            return Boolean.parseBoolean(WEB_RESOURCE_BATCHING_OFF);
        }
        return !DEV_MODE;
    }

    public List<String> getSuperBatchModuleCompleteKeys() {
        return resources;
    }

    static {
        resources.add("com.atlassian.auiplugin:ajs");
        resources.add("jira.webresources:util-lite");
        resources.add("jira.webresources:util");
        resources.add("jira.webresources:inline-layer");
        resources.add("jira.webresources:content-retrievers");
        resources.add("jira.webresources:list");
        resources.add("jira.webresources:dropdown");
        resources.add("jira.webresources:issue-table");
        resources.add("jira.webresources:dropdown-select");
        resources.add("jira.webresources:select-pickers");
        resources.add("jira.webresources:dialogs");
        resources.add("jira.webresources:set-focus");
        resources.add("jira.webresources:jira-global");
        resources.add("jira.webresources:key-commands");
        resources.add("jira.webresources:header");
    }
}

