/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.report.impl;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.report.impl.AbstractReport;
import com.atlassian.jira.plugin.report.impl.SubTaskFetcher;
import com.atlassian.jira.plugin.report.impl.SubTaskIncludeValuesGenerator;
import com.atlassian.jira.plugin.report.impl.SubTasksEnabledCondition;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.bean.PermissionCheckBean;
import com.atlassian.query.order.SortOrder;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.log4j.Logger;

public class VersionWorkloadReport
extends AbstractReport {
    private static final Logger log = Logger.getLogger(VersionWorkloadReport.class);
    private final VersionManager versionManager;
    private final SearchProvider searchProvider;
    private final ConstantsManager constantsManager;
    private final ApplicationProperties applicationProperties;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final UserManager userManager;
    Map user2FullNames = null;
    Map user2Issues = null;
    Map user2RemainingTime = null;
    Map userSummaryTotals = null;
    Map issueTypeTotals = null;
    long grandTotal = 0L;

    public VersionWorkloadReport(VersionManager versionManager, SearchProvider searchProvider, ConstantsManager constantsManager, ApplicationProperties applicationProperties, IssueTypeSchemeManager issueTypeSchemeManager, JiraDurationUtils jiraDurationUtils, UserManager userManager) {
        this.versionManager = versionManager;
        this.searchProvider = searchProvider;
        this.constantsManager = constantsManager;
        this.applicationProperties = applicationProperties;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.jiraDurationUtils = jiraDurationUtils;
        this.userManager = userManager;
        this.user2RemainingTime = new HashMap();
        this.userSummaryTotals = new HashMap();
        this.issueTypeTotals = new HashMap();
        this.user2Issues = new HashMap();
        this.user2FullNames = new HashMap();
    }

    public boolean showReport() {
        return this.applicationProperties.getOption("jira.option.timetracking");
    }

    public String generateReportHtml(ProjectActionSupport action, Map reqParams) throws Exception {
        User remoteUser = action.getLoggedInUser();
        String displayUnknown = (String)reqParams.get("displayUnknown");
        String versionId = (String)reqParams.get("versionId");
        String subtaskInclusion = (String)reqParams.get("subtaskInclusion");
        List issues = this.loadIssues(remoteUser, versionId, subtaskInclusion);
        this.calculateSummaryTotals(issues);
        Collection assigneeUserNames = this.getAssigneeUserNames();
        Version version = this.versionManager.getVersion(new Long(versionId));
        TextUtils textUtils = new TextUtils();
        HashMap<String, Object> velocityParams = new HashMap<String, Object>();
        velocityParams.put("report", (Object)this);
        velocityParams.put("action", action);
        velocityParams.put("version", version);
        velocityParams.put("displayUnknown", displayUnknown);
        velocityParams.put("issueTypes", this.loadIssueTypes(action.getSelectedProjectObject()));
        velocityParams.put("assigneeUserNames", assigneeUserNames);
        velocityParams.put("textUtils", textUtils);
        velocityParams.put("permissionCheck", new PermissionCheckBean());
        velocityParams.put("subtasksEnabled", new SubTasksEnabledCondition().isEnabled());
        velocityParams.put("subtaskDescription", SubTaskIncludeValuesGenerator.Options.getDescription(subtaskInclusion, this.getI18nBean()));
        return this.descriptor.getHtml("view", velocityParams);
    }

    public String getTotalTimeForUserByIssueType(String user, String type) {
        Long time = null;
        if (this.userSummaryTotals != null) {
            Map userTotals = (Map)this.userSummaryTotals.get(user);
            time = (Long)userTotals.get(type);
        }
        return this.getNiceTimeDuration(time);
    }

    public String getGrandTotal() {
        return this.getNiceTimeDuration(new Long(this.grandTotal));
    }

    public void validate(ProjectActionSupport action, Map params) {
        super.validate(action, params);
        String versionId = (String)params.get("versionId");
        if (!TextUtils.stringSet((String)versionId)) {
            action.addError("versionId", this.getI18nBean().getText("report.versionworkload.version.is.required"));
        } else {
            try {
                if (versionId.equals("-1") || versionId.equals("-2")) {
                    action.addError("versionId", this.getI18nBean().getText("report.versionworkload.please.select.an.actual.version"));
                } else if (this.versionManager.getVersion(new Long(versionId)) == null) {
                    action.addError("versionId", this.getI18nBean().getText("report.versionworkload.version.does.not.exist"));
                }
            }
            catch (Exception e) {
                action.addError("versionId", this.getI18nBean().getText("report.versionworkload.version.does.not.exist"));
            }
        }
    }

    List loadIssues(User remoteUser, String versionId, String subtaskInclusion) throws Exception {
        JqlQueryBuilder queryBuilder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder whereBuilder = queryBuilder.where().unresolved();
        if (versionId != null) {
            whereBuilder.and().fixVersion(versionId);
        }
        queryBuilder.orderBy().priority(SortOrder.DESC);
        List issues = this.searchProvider.search(queryBuilder.buildQuery(), remoteUser, PagerFilter.getUnlimitedFilter()).getIssues();
        ListOrderedSet result = new ListOrderedSet();
        result.addAll((Collection)issues);
        List<Issue> subTasks = new SubTaskFetcher(this.searchProvider).getSubTasks(remoteUser, issues, subtaskInclusion, true);
        result.addAll(subTasks);
        return Collections.unmodifiableList(result.asList());
    }

    protected List loadIssueTypes(Project project) {
        return new ArrayList(this.issueTypeSchemeManager.getIssueTypesForProject(project));
    }

    protected void calculateSummaryTotals(Collection issues) {
        String unassignedKey = this.getI18nBean().getText("common.concepts.unassigned");
        for (Issue issue : issues) {
            String assignee;
            User assigneeUser = issue.getAssignee();
            if (assigneeUser != null) {
                assignee = assigneeUser.getName();
                if (this.user2FullNames.get(assignee) == null) {
                    this.user2FullNames.put(assignee, assigneeUser.getDisplayName());
                }
            } else {
                assignee = unassignedKey;
            }
            if (this.userSummaryTotals.get(assignee) == null) {
                this.userSummaryTotals.put(assignee, new HashMap());
            }
            String issueTypeId = issue.getIssueTypeObject().getId();
            Long issueEstimate = issue.getEstimate();
            this.calculateTotalTime(issueTypeId, issueEstimate);
            this.calcuateUserTotalTime(assignee, issueEstimate);
            this.calculateUserTypeTotalTime(assignee, issueTypeId, issueEstimate);
            this.buildUser2Issues(issue, assignee, unassignedKey);
        }
    }

    private void calculateUserTypeTotalTime(String assignee, String issueType, Long issueEstimate) {
        Map userTotalMap = (Map)this.userSummaryTotals.get(assignee);
        if (userTotalMap.get(issueType) == null) {
            if (issueEstimate != null) {
                userTotalMap.put(issueType, issueEstimate);
            }
        } else {
            Long estimate = (Long)userTotalMap.get(issueType);
            if (estimate != null && issueEstimate != null) {
                Long newEstimate = new Long(estimate + issueEstimate);
                userTotalMap.put(issueType, newEstimate);
            }
        }
    }

    private void calcuateUserTotalTime(String assignee, Long issueEstimate) {
        Long lRemainingTime = (Long)this.user2RemainingTime.get(assignee);
        if (issueEstimate != null) {
            if (lRemainingTime == null) {
                lRemainingTime = new Long(0L);
            }
            long remainingTime = lRemainingTime;
            this.user2RemainingTime.put(assignee, new Long(remainingTime += issueEstimate.longValue()));
        }
    }

    private void calculateTotalTime(String issueType, Long issueEstimate) {
        Long currentTypeTotal = (Long)this.issueTypeTotals.get(issueType);
        if (currentTypeTotal != null && issueEstimate != null) {
            long newTypeTotal = currentTypeTotal + issueEstimate;
            this.issueTypeTotals.put(issueType, new Long(newTypeTotal));
        } else if (issueEstimate != null) {
            this.issueTypeTotals.put(issueType, issueEstimate);
        }
        if (issueEstimate != null) {
            this.grandTotal += issueEstimate.longValue();
        }
    }

    private void buildUser2Issues(Issue issue, String assignee, String unassignedKey) {
        ArrayList<Issue> unassignedList = (ArrayList<Issue>)this.user2Issues.get(unassignedKey);
        if (assignee == null) {
            if (unassignedList == null) {
                unassignedList = new ArrayList<Issue>();
                this.user2Issues.put(unassignedKey, unassignedList);
            }
            unassignedList.add(issue);
        } else {
            ArrayList<Issue> assigneeList = (ArrayList<Issue>)this.user2Issues.get(assignee);
            if (assigneeList == null) {
                assigneeList = new ArrayList<Issue>();
                this.user2Issues.put(assignee, assigneeList);
            }
            assigneeList.add(issue);
        }
    }

    private Collection getAssigneeUserNames() {
        ArrayList result = new ArrayList(this.user2Issues.keySet());
        Collections.sort(result, new Comparator(){

            public int compare(Object o1, Object o2) {
                String l1 = (String)o1;
                String l2 = (String)o2;
                if (l1.equals(VersionWorkloadReport.this.getI18nBean().getText("common.concepts.unassigned"))) {
                    return 1;
                }
                if (l2.equals(VersionWorkloadReport.this.getI18nBean().getText("common.concepts.unassigned"))) {
                    return -1;
                }
                User user1 = VersionWorkloadReport.this.userManager.getUserEvenWhenUnknown(l1);
                if (user1 == null) {
                    String errMsg = "Could not find user " + l1;
                    throw new IllegalArgumentException(errMsg);
                }
                User user2 = VersionWorkloadReport.this.userManager.getUserEvenWhenUnknown(l2);
                if (user2 == null) {
                    String errMsg = "Could not find user " + l2;
                    throw new IllegalArgumentException(errMsg);
                }
                return user1.getDisplayName().compareTo(user2.getDisplayName());
            }
        });
        return result;
    }

    private String getNiceTimeDuration(long duration) {
        return this.jiraDurationUtils.getFormattedDuration(new Long(duration), this.descriptor.getI18nBean().getLocale());
    }

    private String getNiceTimeDuration(Long duration) {
        if (duration == null) {
            return this.getI18nBean().getText("report.versionworkload.no.estimate");
        }
        return this.getNiceTimeDuration((long)duration);
    }

    private I18nHelper getI18nBean() {
        return this.getDescriptor().getI18nBean();
    }

    public Collection getIssuesByType(String user, String typeId) {
        ArrayList<Issue> result = new ArrayList<Issue>();
        for (Issue issue : (Collection)this.user2Issues.get(user)) {
            if (!issue.getIssueTypeObject().getId().equals(typeId)) continue;
            result.add(issue);
        }
        return result;
    }

    public String getRemainingTime(String assignee) {
        Long time = (Long)this.user2RemainingTime.get(assignee);
        return this.getNiceTimeDuration(time);
    }

    public String getIssueTypeTotal(String issueType) {
        Long time = (Long)this.issueTypeTotals.get(issueType);
        return this.getNiceTimeDuration(time);
    }

    public String getNiceTimeEstimateDuration(Issue issue) {
        return this.getNiceTimeDuration(issue.getEstimate());
    }

    public String getAssigneeFullName(String username) {
        String userFullName = (String)this.user2FullNames.get(username);
        return userFullName == null ? username : userFullName;
    }
}

