/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.issuelink;

import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.issuelink.IssueLinkRenderer;
import com.atlassian.jira.plugin.issuelink.IssueLinkRendererModuleDescriptor;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.util.validation.ValidationPattern;
import java.util.Map;
import org.dom4j.Element;

public class IssueLinkRendererModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<IssueLinkRenderer>
implements IssueLinkRendererModuleDescriptor {
    public static final String XML_ELEMENT_NAME = "issue-link-renderer";
    public static final String INITIAL_VIEW_RESOURCE_NAME = "initial-view";
    public static final String FINAL_VIEW_RESOURCE_NAME = "final-view";
    private String applicationType;
    private boolean defaultHandler;

    public IssueLinkRendererModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.applicationType = element.attributeValue("application-type");
        this.defaultHandler = Boolean.parseBoolean(element.attributeValue("default-handler"));
    }

    public void enabled() {
        super.enabled();
        this.assertModuleClassImplements(IssueLinkRenderer.class);
    }

    protected void provideValidationRules(ValidationPattern pattern) {
        super.provideValidationRules(pattern);
        pattern.rule(new ValidationPattern.RuleTest[]{ValidationPattern.test((String)"@application-type").withError("The application type is required")});
    }

    public boolean isDefaultHandler() {
        return this.defaultHandler;
    }

    public boolean handlesApplicationType(String applicationType) {
        return this.applicationType != null && this.applicationType.equals(applicationType);
    }

    public String getInitialHtml(RemoteIssueLink remoteIssueLink, Map<String, Object> context) {
        return this.getHtml(INITIAL_VIEW_RESOURCE_NAME, ((IssueLinkRenderer)this.getModule()).getInitialContext(remoteIssueLink, context));
    }

    public String getFinalHtml(RemoteIssueLink remoteIssueLink, Map<String, Object> context) {
        return this.getHtml(FINAL_VIEW_RESOURCE_NAME, ((IssueLinkRenderer)this.getModule()).getFinalContext(remoteIssueLink, context));
    }
}

