/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.TabPanelModuleDescriptor;
import com.atlassian.jira.plugin.browsepanel.TabPanel;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.web.util.IssueTableBean;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Element;

public abstract class AbstractTabPanelModuleDescriptor<T extends TabPanel>
extends AbstractJiraModuleDescriptor<T>
implements TabPanelModuleDescriptor<T> {
    private String label = "Unknown";
    private String labelKey;
    protected int order;

    public AbstractTabPanelModuleDescriptor(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        Element labelEl = element.element("label");
        if (labelEl != null) {
            if (labelEl.attribute("key") != null) {
                this.labelKey = labelEl.attributeValue("key");
            } else {
                this.label = labelEl.getTextTrim();
            }
        }
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
    }

    public void enabled() {
        super.enabled();
        this.assertModuleClass();
    }

    protected abstract void assertModuleClass() throws PluginParseException;

    public int getOrder() {
        return this.order;
    }

    public String getLabel() {
        if (this.labelKey != null) {
            return this.getI18nBean().getText(this.labelKey);
        }
        return this.label;
    }

    public String getLabelKey() {
        return this.labelKey;
    }

    protected Map createVelocityParams(Map startingParams) {
        IssueTableBean issueBean = new IssueTableBean();
        HashMap<String, IssueTableBean> velocityParams = new HashMap<String, IssueTableBean>();
        velocityParams.putAll(super.createVelocityParams(startingParams));
        velocityParams.put("issueBean", issueBean);
        return velocityParams;
    }
}

