/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.core.util.HTMLUtils;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.fields.layout.column.ColumnLayout;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchRequestUtils;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.mail.MailingListCompiler;
import com.atlassian.jira.mail.SubscriptionMailQueueMockRequest;
import com.atlassian.jira.notification.NotificationRecipient;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.template.TemplateManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.BuildUtils;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.mail.MailException;
import com.atlassian.mail.queue.AbstractMailQueueItem;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.query.Query;
import com.opensymphony.util.TextUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.velocity.exception.VelocityException;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.ActionContext;

public class SubscriptionMailQueueItem
extends AbstractMailQueueItem {
    private static final Logger log = Logger.getLogger(SubscriptionMailQueueItem.class);
    private final Long FILTER_SUBSCRIPTION_TEMPLATE_ID = new Long("10000");
    private GenericValue subscription;
    private SearchRequest request;
    private User subscriptionCreator;
    private TemplateManager templateManager;
    private final UserManager userManager;
    private final GroupManager groupManager;
    private final MailingListCompiler mailingListCompiler;
    private final SearchService searchService;
    private static final int DEFAULT_MAIL_MAX_ISSUES = 200;

    public SubscriptionMailQueueItem(GenericValue sub, MailingListCompiler mailingListCompiler, SearchService searchService, TemplateManager templateManager, UserManager userManager, GroupManager groupManager) {
        this.subscription = sub;
        this.mailingListCompiler = mailingListCompiler;
        this.searchService = searchService;
        this.templateManager = templateManager;
        this.userManager = userManager;
        this.groupManager = groupManager;
    }

    public void send() throws MailException {
        this.incrementSendCount();
        String groupName = this.subscription.getString("group");
        if (TextUtils.stringSet((String)groupName)) {
            Group group = this.userManager.getGroup(groupName);
            if (group == null) {
                log.warn((Object)("Group '" + groupName + "' referenced in subscription '" + this.subscription.getLong("id") + "' of filter '" + this.subscription.getLong("filterID") + "' does not exist."));
                return;
            }
            try {
                Collection groupUser = this.groupManager.getUsersInGroup(groupName);
                for (User user : groupUser) {
                    this.sendSearchRequestEmail(user);
                }
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
                throw new MailException((Throwable)ex);
            }
        }
        String userName = this.subscription.getString("username");
        User user = this.getSubscriptionUser();
        if (user == null) {
            log.warn((Object)("User '" + userName + "' referenced in subscription '" + this.subscription.getLong("id") + "' of filter '" + this.subscription.getLong("filterID") + "' does not exist."));
        } else {
            try {
                this.sendSearchRequestEmail(user);
            }
            catch (Exception ex) {
                log.error((Object)ex, (Throwable)ex);
                throw new MailException((Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendSearchRequestEmail(User user) throws Exception, GenericEntityException, VelocityException {
        JiraAuthenticationContext jiraAuthenticationContext = ComponentAccessor.getJiraAuthenticationContext();
        User originalUser = jiraAuthenticationContext.getUser();
        jiraAuthenticationContext.setLoggedInUser(user);
        try {
            Map params = this.getContextParams(this.subscription, this.getSearchRequest(), user);
            HashSet<NotificationRecipient> recipient = new HashSet<NotificationRecipient>();
            recipient.add(new NotificationRecipient(user));
            if (this.subscription == null) {
                throw new RuntimeException("Null subscription for user " + (user == null ? "null" : user.getName()));
            }
            String emailOnEmptyStr = this.subscription.getString("emailOnEmpty");
            if (emailOnEmptyStr == null) {
                throw new RuntimeException("emailOnEmpty not set for subscription " + this.subscription + ", user " + user);
            }
            if (params.get("issues") == null) {
                throw new RuntimeException("Null list of issues for subscription " + this.subscription + ", user " + user);
            }
            if (user != null && user.equals(this.getSubscriptionUser())) {
                params.put("recipientIsAuthor", Boolean.TRUE);
            }
            if (Boolean.valueOf(emailOnEmptyStr).booleanValue() || !((Collection)params.get("issues")).isEmpty()) {
                this.mailingListCompiler.sendLists(recipient, null, null, this.FILTER_SUBSCRIPTION_TEMPLATE_ID, ManagerFactory.getApplicationProperties().getString("jira.baseurl"), params, null);
            }
        }
        finally {
            jiraAuthenticationContext.setLoggedInUser(originalUser);
        }
    }

    public IssueTableLayoutBean getTableLayout(User user) throws Exception {
        Query query;
        SearchRequest searchRequest = this.getSearchRequest();
        List searchSorts = null;
        if (searchRequest != null && (query = searchRequest.getQuery()).getOrderByClause() != null) {
            searchSorts = query.getOrderByClause().getSearchSorts();
        }
        IssueTableLayoutBean bean = new IssueTableLayoutBean(this.getColumns(user), searchSorts);
        bean.setSortingEnabled(false);
        bean.addCellDisplayParam("email_view", Boolean.TRUE);
        return bean;
    }

    public List getColumns(User user) throws Exception {
        SearchRequest searchRequest = this.getSearchRequest();
        ColumnLayout columnLayout = null;
        columnLayout = searchRequest != null && searchRequest.isLoaded() && searchRequest.useColumns() ? ManagerFactory.getFieldManager().getColumnLayoutManager().getColumnLayout(user, this.getSearchRequest()) : ManagerFactory.getFieldManager().getColumnLayoutManager().getColumnLayout(user);
        if (searchRequest == null) {
            return columnLayout.getAllVisibleColumnLayoutItems(user);
        }
        Query query = searchRequest.getQuery();
        QueryContext queryContext = this.searchService.getQueryContext(user, query);
        return columnLayout.getVisibleColumnLayoutItems(user, queryContext);
    }

    public String getSubject() {
        I18nHelper.BeanFactory i18nFactory = ComponentManager.getComponentInstanceOfType(I18nHelper.BeanFactory.class);
        I18nHelper i18n = i18nFactory.getInstance(ComponentAccessor.getApplicationProperties().getDefaultLocale());
        try {
            String subjectTemplate = this.templateManager.getTemplateContent(this.FILTER_SUBSCRIPTION_TEMPLATE_ID, "subject");
            Map contextParams = this.getContextParams(this.subscription, this.getSearchRequest(), null);
            contextParams.put("i18n", i18n);
            OutlookDate formatter = new OutlookDate(i18n.getLocale());
            contextParams.put("dateformatter", formatter);
            return ManagerFactory.getVelocityManager().getEncodedBodyForContent(subjectTemplate, ManagerFactory.getApplicationProperties().getString("jira.baseurl"), contextParams);
        }
        catch (Exception e) {
            log.error((Object)"Could not determine subject", (Throwable)e);
            return i18n.getText("bulk.bean.initialise.error");
        }
    }

    private SearchRequest getSearchRequest() throws GenericEntityException {
        if (this.request == null) {
            JiraServiceContextImpl ctx = new JiraServiceContextImpl(this.getSubscriptionUser());
            this.request = ComponentManager.getInstance().getSearchRequestService().getFilter((JiraServiceContext)ctx, this.subscription.getLong("filterID"));
        }
        return this.request;
    }

    private User getSubscriptionUser() {
        if (this.subscriptionCreator == null) {
            this.subscriptionCreator = this.userManager.getUser(this.subscription.getString("username"));
        }
        return this.subscriptionCreator;
    }

    private Map getContextParams(GenericValue sub, SearchRequest sr, User u) throws Exception {
        String baseURL = ManagerFactory.getApplicationProperties().getString("jira.baseurl");
        String contextPath = this.getContextPath(baseURL);
        SearchProvider searcher = ComponentManager.getInstance().getSearchProvider();
        HashMap<String, Object> contextParams = new HashMap<String, Object>();
        IssueTableLayoutBean tableLayout = this.getTableLayout(u);
        IssueTableWebComponent iwtc = new IssueTableWebComponent();
        ActionContext oldCtx = ActionContext.getContext();
        ActionContext.setContext((ActionContext)new ActionContext());
        ActionContext.setRequest((HttpServletRequest)new SubscriptionMailQueueMockRequest(contextPath));
        ActionContext.setContext((ActionContext)oldCtx);
        if (u != null) {
            SearchResults results = searcher.search(sr != null ? sr.getQuery() : null, u, this.getPageFilter());
            List issues = results.getIssues();
            String issueTableHtml = iwtc.getHtml(tableLayout, issues, null);
            contextParams.put("totalIssueCount", new Integer(results.getTotal()));
            contextParams.put("actualIssueCount", new Integer(issues.size()));
            contextParams.put("issueTableHtml", issueTableHtml);
            contextParams.put("issues", issues);
            contextParams.put("user", u);
        }
        contextParams.put("baseHREF", this.getBaseURLWithoutContext(baseURL));
        contextParams.put("constantsManager", ManagerFactory.getConstantsManager());
        contextParams.put("req", new SubscriptionMailQueueMockRequest(contextPath));
        contextParams.put("searchRequest", sr);
        contextParams.put("SRUtils", new SearchRequestUtils());
        contextParams.put("subscription", sub);
        contextParams.put("StringUtils", new StringUtils());
        contextParams.put("HTMLUtils", new HTMLUtils());
        contextParams.put("buildutils", new BuildUtils());
        contextParams.put("textutils", new TextUtils());
        contextParams.put("webResourceManager", ComponentAccessor.getWebResourceManager());
        contextParams.put("urlModeAbsolute", UrlMode.ABSOLUTE);
        return contextParams;
    }

    private String getContextPath(String baseURL) {
        try {
            URL url = new URL(baseURL);
            return url.getPath();
        }
        catch (MalformedURLException e) {
            log.error((Object)("Incorrect baseURL format: " + baseURL));
            return "";
        }
    }

    private String getBaseURLWithoutContext(String baseURL) {
        String path = this.getContextPath(baseURL);
        return StringUtils.chomp((String)baseURL, (String)path);
    }

    private PagerFilter getPageFilter() {
        int maxEmail;
        String application = ManagerFactory.getApplicationProperties().getDefaultBackedString("jira.subscription.email.max.issues");
        if (StringUtils.isBlank((String)application)) {
            log.warn((Object)"The maximum number of issues to include in subscription email '(jira.subscription.email.max.issues)' is not configured. Using default of 200");
            maxEmail = 200;
        } else {
            try {
                maxEmail = Integer.parseInt(application);
                if (maxEmail == 0) {
                    log.warn((Object)"The maximum number of issues to include in subscription email '(jira.subscription.email.max.issues)' cannot be zero. Using default of 200");
                    maxEmail = 200;
                } else if (maxEmail < 0) {
                    maxEmail = -1;
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)"The maximum number of issues to include in subscription email '(jira.subscription.email.max.issues)' is not a valid number. Using default of 200");
                maxEmail = 200;
            }
        }
        return new PagerFilter(maxEmail);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubscriptionMailQueueItem)) {
            return false;
        }
        SubscriptionMailQueueItem subscriptionMailQueueItem = (SubscriptionMailQueueItem)((Object)o);
        if (this.request != null ? !this.request.equals((Object)subscriptionMailQueueItem.request) : subscriptionMailQueueItem.request != null) {
            return false;
        }
        if (!this.subscription.equals((Object)subscriptionMailQueueItem.subscription)) {
            return false;
        }
        return !(this.subscriptionCreator != null ? !this.subscriptionCreator.equals(subscriptionMailQueueItem.subscriptionCreator) : subscriptionMailQueueItem.subscriptionCreator != null);
    }

    public int hashCode() {
        int result = this.subscription.hashCode();
        result = 29 * result + (this.request != null ? this.request.hashCode() : 0);
        result = 29 * result + (this.subscriptionCreator != null ? this.subscriptionCreator.hashCode() : 0);
        return result;
    }

    public String toString() {
        User subscriptionUser = this.getSubscriptionUser();
        return ((Object)((Object)this)).getClass().getName() + " owner: '" + subscriptionUser + "'";
    }
}

