/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.mail;

import com.atlassian.jira.mail.MailLoggingManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.admin.mail.LogPrintStream;
import com.atlassian.mail.server.MailServer;
import com.atlassian.mail.server.MailServerConfigurationHandler;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.PopMailServer;
import com.atlassian.mail.server.SMTPMailServer;
import java.io.PrintStream;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LoggerFactory;

public class DefaultMailLoggingManager
implements MailLoggingManager {
    private static final Logger outgoingMailLogger = Logger.getLogger((String)"com.atlassian.mail.outgoing");
    private static final Logger incomingMailLogger = Logger.getLogger((String)"com.atlassian.mail.incoming");
    private final LogPrintStream outgoingMailLoggerStream = new LogPrintStream(outgoingMailLogger, Level.DEBUG);
    private final LogPrintStream incomingMailLoggerStream = new LogPrintStream(incomingMailLogger, Level.DEBUG);

    public DefaultMailLoggingManager(MailServerManager mailServerManager) {
        mailServerManager.setMailServerConfigurationHandler(new MailServerConfigurationHandler(){

            public void configureMailServer(MailServer mailServer) {
                if (mailServer instanceof SMTPMailServer) {
                    outgoingMailLogger.trace((Object)("Configuring SMTPMailServer [" + mailServer + "]"));
                    SMTPMailServer smtpMailServer = (SMTPMailServer)mailServer;
                    smtpMailServer.setDebugStream((PrintStream)DefaultMailLoggingManager.this.outgoingMailLoggerStream);
                    mailServer.setDebug(DefaultMailLoggingManager.this.getOutgoingMailLoggingLevel() == Level.DEBUG);
                    mailServer.setLogger(outgoingMailLogger);
                } else if (mailServer instanceof PopMailServer) {
                    incomingMailLogger.trace((Object)("Configuring PopMailServer [" + mailServer + "]"));
                    mailServer.setDebug(DefaultMailLoggingManager.this.getIncomingMailLoggingLevel() == Level.DEBUG);
                    mailServer.setDebugStream((PrintStream)DefaultMailLoggingManager.this.incomingMailLoggerStream);
                    mailServer.setLogger(incomingMailLogger);
                }
                MDC.put((String)"jira.mailserver", (Object)mailServer.getName());
            }
        });
    }

    public synchronized Level getOutgoingMailLoggingLevel() {
        return outgoingMailLogger.getEffectiveLevel();
    }

    public synchronized Level getIncomingMailLoggingLevel() {
        return incomingMailLogger.getEffectiveLevel();
    }

    public synchronized void setOutgoingMailLoggingLevel(Level loggingLevel) {
        Assertions.notNull((String)"LoggingLevel cannot be null", (Object)loggingLevel);
        outgoingMailLogger.setLevel(loggingLevel);
    }

    public synchronized void setIncomingMailLoggingLevel(Level loggingLevel) {
        Assertions.notNull((String)"LoggingLevel cannot be null", (Object)loggingLevel);
        incomingMailLogger.setLevel(loggingLevel);
    }

    public Logger getOutgoingMailLogger() {
        return outgoingMailLogger;
    }

    public Logger getIncomingMailLogger() {
        return incomingMailLogger;
    }

    public Logger getIncomingMailChildLogger(String subname) {
        String loggerName = incomingMailLogger.getName() + "." + subname;
        return LogManager.getLogger((String)loggerName, (LoggerFactory)new LoggerFactory(){

            public Logger makeNewLoggerInstance(String name) {
                return new Logger(name){

                    public void setLevel(Level level) {
                    }
                };
            }
        });
    }

    public boolean isMailRelatedLogger(Logger logger) {
        String name = logger.getName();
        return name != null && name.startsWith("com.atlassian.mail");
    }
}

