/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.license;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.license.JiraLicenseStore;
import com.atlassian.jira.license.LicenseStringFactory;
import com.atlassian.jira.util.dbc.Assertions;

public class JiraLicenseStoreImpl
implements JiraLicenseStore {
    private static final String ENTERPRISE = "enterprise";
    private final ApplicationProperties applicationProperties;
    private final LicenseStringFactory licenseStringFactory;

    public JiraLicenseStoreImpl(ApplicationProperties applicationProperties, LicenseStringFactory licenseStringFactory) {
        this.licenseStringFactory = (LicenseStringFactory)Assertions.notNull((String)"licenseStringFactory", (Object)licenseStringFactory);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)applicationProperties);
    }

    @Override
    public String retrieve() {
        String licenseString = this.applicationProperties.getText("License20");
        if (StringUtils.isBlank((String)licenseString)) {
            licenseString = this.retreiveFromOldKeys();
        }
        if (StringUtils.isBlank((String)licenseString)) {
            licenseString = this.retriveFromReallyOldKeys();
        }
        return licenseString;
    }

    private String retreiveFromOldKeys() {
        return this.retrieveFromMessageAndHash(this.applicationProperties.getText("License Message Text"), this.applicationProperties.getText("License Hash 1 Text"));
    }

    private String retriveFromReallyOldKeys() {
        return this.retrieveFromMessageAndHash(this.applicationProperties.getString("License Message"), this.applicationProperties.getString("License Hash 1"));
    }

    private String retrieveFromMessageAndHash(String msg, String hash) {
        if (StringUtils.isNotBlank((String)msg) && StringUtils.isNotBlank((String)hash)) {
            return this.licenseStringFactory.create(msg, hash);
        }
        return null;
    }

    @Override
    public void store(String licenseString) {
        if (StringUtils.isBlank((String)licenseString)) {
            throw new IllegalArgumentException("You can't store an empty license");
        }
        this.applicationProperties.setText("License20", this.removeWhitespace(licenseString));
        this.applicationProperties.setString("jira.edition", ENTERPRISE);
    }

    private String removeWhitespace(String licenseString) {
        if (StringUtils.isBlank((String)licenseString)) {
            return licenseString;
        }
        StringBuilder sb = new StringBuilder();
        for (char ch : licenseString.toCharArray()) {
            if (Character.isWhitespace(ch)) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    @Override
    public void resetOldBuildConfirmation() {
        this.applicationProperties.setOption("jira.install.oldlicense.confirmed", false);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.timestamp", "");
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.user", "");
    }

    @Override
    public void confirmProceedUnderEvaluationTerms(String userName) {
        this.applicationProperties.setOption("jira.install.oldlicense.confirmed", true);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.user", userName);
        this.applicationProperties.setString("jira.install.oldlicense.confirmed.timestamp", String.valueOf(System.currentTimeMillis()));
    }

    @Override
    public String retrieveServerId() {
        return this.applicationProperties.getString("jira.sid.key");
    }

    @Override
    public void storeServerId(String serverId) {
        this.applicationProperties.setString("jira.sid.key", serverId);
    }
}

