/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.PredicateOperandResolver;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.ChangeHistoryFieldIdResolver;
import com.atlassian.jira.jql.util.DateRange;
import com.atlassian.jira.jql.util.JqlDateSupport;
import com.atlassian.query.history.AndHistoryPredicate;
import com.atlassian.query.history.HistoryPredicate;
import com.atlassian.query.history.TerminalHistoryPredicate;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operator.Operator;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;

public class HistoryPredicateQueryFactory {
    private final PredicateOperandResolver predicateOperandResolver;
    private final JqlDateSupport jqlDateSupport;
    private final ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver;
    private static final Date MAX_DATE = new Date(Long.MAX_VALUE);
    private static final Date MIN_DATE = new Date(0L);
    private static final Query FALSE_QUERY = new BooleanQuery();

    public HistoryPredicateQueryFactory(PredicateOperandResolver predicateOperandResolver, JqlDateSupport jqlDateSupport, ChangeHistoryFieldIdResolver changeHistoryFieldIdResolver) {
        this.predicateOperandResolver = predicateOperandResolver;
        this.jqlDateSupport = jqlDateSupport;
        this.changeHistoryFieldIdResolver = changeHistoryFieldIdResolver;
    }

    public BooleanQuery makePredicateQuery(User searcher, String field, HistoryPredicate historyPredicate, boolean isChangedSearch) {
        BooleanQuery predicateQuery = new BooleanQuery();
        ArrayList<TerminalHistoryPredicate> terminalPredicates = new ArrayList<TerminalHistoryPredicate>();
        if (historyPredicate instanceof AndHistoryPredicate) {
            for (HistoryPredicate historyPredicate2 : ((AndHistoryPredicate)historyPredicate).getPredicates()) {
                terminalPredicates.add((TerminalHistoryPredicate)historyPredicate2);
            }
        } else {
            terminalPredicates.add((TerminalHistoryPredicate)historyPredicate);
        }
        for (TerminalHistoryPredicate terminalHistoryPredicate : terminalPredicates) {
            this.makeBooleanQuery(searcher, field, terminalHistoryPredicate, predicateQuery, isChangedSearch);
        }
        return predicateQuery;
    }

    private void makeBooleanQuery(User searcher, String field, TerminalHistoryPredicate predicate, BooleanQuery predicateQuery, boolean isChangedSearch) {
        Preconditions.checkNotNull((Object)predicate, (Object)"Must provide a predicate");
        Preconditions.checkNotNull((Object)predicateQuery, (Object)"must provide a predicateQuery");
        Operator operator = predicate.getOperator();
        Operand operand = predicate.getOperand();
        List<QueryLiteral> operandValues = this.predicateOperandResolver.getValues(searcher, operand);
        if (operandValues == null || operandValues.isEmpty()) {
            return;
        }
        if (Operator.BY.equals((Object)operator)) {
            this.makeBYQuery(predicateQuery, operandValues);
        }
        if (Operator.TO.equals((Object)operator)) {
            this.makeChangedQuery(field, predicateQuery, operandValues, true);
        }
        if (Operator.FROM.equals((Object)operator)) {
            this.makeChangedQuery(field, predicateQuery, operandValues, false);
        }
        if (OperatorClasses.CHANGE_HISTORY_DATE_PREDICATES.contains(operator)) {
            if (Operator.DURING.equals((Object)operator)) {
                this.makeDURINGQuery(predicateQuery, operandValues, field, isChangedSearch);
            } else if (Operator.ON.equals((Object)operator)) {
                this.makeONQuery(predicateQuery, operandValues, field, isChangedSearch);
            } else {
                this.makeBEFOREorAFTERQuery(operator, predicateQuery, operandValues, field, isChangedSearch);
            }
        }
    }

    private void makeChangedQuery(String fieldName, BooleanQuery predicateQuery, List<QueryLiteral> operandValues, boolean isUpperBounds) {
        BooleanQuery changedQuery = new BooleanQuery();
        String documentField = isUpperBounds ? "ch_newvalue" : "ch_oldvalue";
        for (QueryLiteral literal : operandValues) {
            Collection ids = this.changeHistoryFieldIdResolver.resolveIdsForField(fieldName, literal, literal.isEmpty());
            for (String id : ids) {
                changedQuery.add((Query)new TermQuery(new Term(fieldName.toLowerCase() + "." + documentField, this.encodeProtocol(id))), BooleanClause.Occur.SHOULD);
            }
        }
        predicateQuery.add((Query)changedQuery, BooleanClause.Occur.MUST);
    }

    private void makeBYQuery(BooleanQuery predicateQuery, List<QueryLiteral> operandValues) {
        BooleanQuery userQuery = new BooleanQuery();
        for (QueryLiteral literal : operandValues) {
            userQuery.add((Query)new TermQuery(new Term("ch_who", this.encodeProtocol(literal.getStringValue()))), BooleanClause.Occur.SHOULD);
        }
        predicateQuery.add((Query)userQuery, BooleanClause.Occur.MUST);
    }

    private void makeDURINGQuery(BooleanQuery predicateQuery, List<QueryLiteral> operandValues, String field, boolean isChangedSearch) {
        if (operandValues.size() < 2) {
            predicateQuery.add(FALSE_QUERY, BooleanClause.Occur.MUST);
        } else {
            DateRange bottomBoundDateRange = this.convertToDateRangeWithImpliedPrecision(operandValues.get(0));
            DateRange upperBoundDateRange = this.convertToDateRangeWithImpliedPrecision(operandValues.get(1));
            if (bottomBoundDateRange == null || upperBoundDateRange == null) {
                predicateQuery.add(FALSE_QUERY, BooleanClause.Occur.MUST);
            } else {
                this.makeInclusiveQueryBasedOnDates(predicateQuery, field, bottomBoundDateRange.getLowerDate(), upperBoundDateRange.getUpperDate(), isChangedSearch);
            }
        }
    }

    private void makeONQuery(BooleanQuery predicateQuery, List<QueryLiteral> operandValues, String field, boolean isChangedSearch) {
        BooleanQuery query = new BooleanQuery();
        for (QueryLiteral literal : operandValues) {
            DateRange dateRange = this.convertToDateRangeWithImpliedPrecision(literal);
            if (dateRange == null) {
                query.add(FALSE_QUERY, BooleanClause.Occur.MUST);
                return;
            }
            BooleanQuery condition = new BooleanQuery();
            this.makeInclusiveQueryBasedOnDates(condition, field, dateRange.getLowerDate(), dateRange.getUpperDate(), isChangedSearch);
            query.add((Query)condition, BooleanClause.Occur.SHOULD);
        }
        predicateQuery.add((Query)query, BooleanClause.Occur.MUST);
    }

    private Date addOneUnit(Date lowerDate) {
        return DateUtils.addSeconds((Date)lowerDate, (int)1);
    }

    private void makeBEFOREorAFTERQuery(Operator operator, BooleanQuery predicateQuery, List<QueryLiteral> operandValues, String field, boolean isChangedSearch) {
        QueryLiteral literal = operandValues.get(0);
        DateRange dateRange = this.convertToDateRangeWithImpliedPrecision(literal);
        if (dateRange == null) {
            predicateQuery.add(FALSE_QUERY, BooleanClause.Occur.MUST);
        } else if (Operator.BEFORE.equals((Object)operator)) {
            this.makeExclusiveQueryBasedOnDates(predicateQuery, field, MIN_DATE, dateRange.getLowerDate(), isChangedSearch);
        } else if (Operator.AFTER.equals((Object)operator)) {
            this.makeExclusiveQueryBasedOnDates(predicateQuery, field, this.addOneUnit(dateRange.getUpperDate()), MAX_DATE, isChangedSearch);
        }
    }

    public void makeExclusiveQueryBasedOnDates(BooleanQuery bq, String field, Date fromDate, Date toDate, boolean isChangedSearch) {
        this.makeTermQueryImpl(bq, field, fromDate, toDate, false, isChangedSearch);
    }

    public void makeInclusiveQueryBasedOnDates(BooleanQuery bq, String field, Date fromDate, Date toDate, boolean isChangedSearch) {
        this.makeTermQueryImpl(bq, field, fromDate, toDate, true, isChangedSearch);
    }

    public void makeTermQueryImpl(BooleanQuery bq, String field, Date fromDate, Date toDate, boolean inclusiveSearch, boolean isChangedSearch) {
        if (fromDate != null && toDate != null) {
            fromDate = inclusiveSearch ? this.addOneUnit(fromDate) : fromDate;
            String searchStart = this.jqlDateSupport.getIndexedValue(fromDate);
            String searchEnd = this.jqlDateSupport.getIndexedValue(toDate);
            if (isChangedSearch) {
                bq.add((Query)new TermRangeQuery("ch_date", searchStart, searchEnd, true, inclusiveSearch), BooleanClause.Occur.MUST);
            } else {
                bq.add((Query)new TermRangeQuery(field + "." + "ch_nextchangedate", searchStart, null, inclusiveSearch, true), BooleanClause.Occur.MUST);
                bq.add((Query)new TermRangeQuery("ch_date", null, searchEnd, true, inclusiveSearch), BooleanClause.Occur.MUST);
            }
        }
    }

    private DateRange convertToDateRangeWithImpliedPrecision(QueryLiteral literal) {
        return literal == null ? null : (literal.getLongValue() != null ? this.jqlDateSupport.convertToDateRange(literal.getLongValue()) : this.jqlDateSupport.convertToDateRangeWithImpliedPrecision(literal.getStringValue()));
    }

    private String encodeProtocol(String changeItem) {
        return "ch-" + (changeItem == null ? "" : changeItem.toLowerCase());
    }
}

