/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.operand;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.jql.operand.FunctionOperandHandler;
import com.atlassian.jira.jql.operand.PredicateOperandHandler;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operand.registry.JqlFunctionHandlerRegistry;
import com.atlassian.jira.jql.query.QueryCreationContext;
import com.atlassian.jira.jql.query.QueryCreationContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.Operand;
import com.atlassian.query.operand.SingleValueOperand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class PredicateOperandHandlerRegistry {
    private static final Logger log = Logger.getLogger(PredicateOperandHandlerRegistry.class);
    private final JqlFunctionHandlerRegistry functionRegistry;
    private final I18nHelper.BeanFactory factory;
    private final JiraAuthenticationContext authContext;

    public PredicateOperandHandlerRegistry(JqlFunctionHandlerRegistry functionRegistry, I18nHelper.BeanFactory factory, JiraAuthenticationContext authContext) {
        this.authContext = (JiraAuthenticationContext)Assertions.notNull((String)"authContext", (Object)authContext);
        this.factory = (I18nHelper.BeanFactory)Assertions.notNull((String)"factory", (Object)factory);
        this.functionRegistry = (JqlFunctionHandlerRegistry)Assertions.notNull((String)"functionRegistry", (Object)functionRegistry);
    }

    public PredicateOperandHandler getHandler(User searcher, Operand operand) {
        if (operand instanceof SingleValueOperand) {
            return new SingleValuePredicateOperandHandler(searcher, (SingleValueOperand)operand);
        }
        if (operand instanceof EmptyOperand) {
            return new EmptyPredicateOperandHandler(searcher, (EmptyOperand)operand);
        }
        if (operand instanceof MultiValueOperand) {
            return new MultiValuePredicateOperandHandler(searcher, this, (MultiValueOperand)operand);
        }
        if (operand instanceof FunctionOperand) {
            return new FunctionPredicateOperandHandler(searcher, (FunctionOperand)operand, this.functionRegistry);
        }
        log.warn((Object)String.format("Unknown operand type '%s' with name '%s'", operand.getClass(), operand.getDisplayString()));
        return null;
    }

    static final class FunctionPredicateOperandHandler
    implements PredicateOperandHandler {
        private final FunctionOperand operand;
        private final User searcher;
        private final JqlFunctionHandlerRegistry functionRegistry;

        FunctionPredicateOperandHandler(User searcher, FunctionOperand operand, JqlFunctionHandlerRegistry functionRegistry) {
            this.searcher = searcher;
            this.operand = operand;
            this.functionRegistry = functionRegistry;
        }

        @Override
        public List<QueryLiteral> getValues() {
            FunctionOperandHandler handler = this.functionRegistry.getOperandHandler(this.operand);
            return handler.getValues((QueryCreationContext)new QueryCreationContextImpl(this.searcher), this.operand, (TerminalClause)null);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return true;
        }
    }

    static final class MultiValuePredicateOperandHandler
    implements PredicateOperandHandler {
        private final PredicateOperandHandlerRegistry handlerRegistry;
        private final MultiValueOperand operand;
        private final User searcher;

        MultiValuePredicateOperandHandler(User searcher, PredicateOperandHandlerRegistry handlerRegistry, MultiValueOperand operand) {
            this.searcher = searcher;
            this.handlerRegistry = handlerRegistry;
            this.operand = operand;
        }

        @Override
        public List<QueryLiteral> getValues() {
            ArrayList<QueryLiteral> valuesList = new ArrayList<QueryLiteral>();
            for (Operand subOperand : this.operand.getValues()) {
                List<QueryLiteral> vals = this.handlerRegistry.getHandler(this.searcher, subOperand).getValues();
                if (vals == null) continue;
                valuesList.addAll(vals);
            }
            return valuesList;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isList() {
            return true;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }

    static final class EmptyPredicateOperandHandler
    implements PredicateOperandHandler {
        private final EmptyOperand emptyOperand;
        private final User searcher;

        EmptyPredicateOperandHandler(User searcher, EmptyOperand emptyOperand) {
            this.searcher = searcher;
            this.emptyOperand = emptyOperand;
        }

        @Override
        public List<QueryLiteral> getValues() {
            return Collections.singletonList(new QueryLiteral((Operand)this.emptyOperand));
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }

    static final class SingleValuePredicateOperandHandler
    implements PredicateOperandHandler {
        private final SingleValueOperand singleValueOperand;
        private final User searcher;

        SingleValuePredicateOperandHandler(User searcher, SingleValueOperand singleValueOperand) {
            this.singleValueOperand = singleValueOperand;
            this.searcher = searcher;
        }

        @Override
        public List<QueryLiteral> getValues() {
            if (this.singleValueOperand.getLongValue() == null) {
                return Collections.singletonList(new QueryLiteral((Operand)this.singleValueOperand, this.singleValueOperand.getStringValue()));
            }
            return Collections.singletonList(new QueryLiteral((Operand)this.singleValueOperand, this.singleValueOperand.getLongValue()));
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isList() {
            return false;
        }

        @Override
        public boolean isFunction() {
            return false;
        }
    }
}

