/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.context;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.jql.context.AllIssueTypesContext;
import com.atlassian.jira.jql.context.ClauseContext;
import com.atlassian.jira.jql.context.ClauseContextFactory;
import com.atlassian.jira.jql.context.ClauseContextImpl;
import com.atlassian.jira.jql.context.IssueTypeContext;
import com.atlassian.jira.jql.context.ProjectContext;
import com.atlassian.jira.jql.context.ProjectContextImpl;
import com.atlassian.jira.jql.context.ProjectIssueTypeContext;
import com.atlassian.jira.jql.context.ProjectIssueTypeContextImpl;
import com.atlassian.jira.jql.operand.JqlOperandResolver;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.resolver.IssueSecurityLevelResolver;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.InjectableComponent;
import com.atlassian.jira.util.NonInjectableComponent;
import com.atlassian.jira.util.Predicate;
import com.atlassian.jira.util.Predicates;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operator.Operator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

@NonInjectableComponent
public class IssueSecurityLevelClauseContextFactory
implements ClauseContextFactory {
    private static final Logger log = Logger.getLogger(IssueSecurityLevelClauseContextFactory.class);
    private final JqlOperandResolver jqlOperandResolver;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final ProjectManager projectManager;
    private final IssueSecurityLevelResolver issueSecurityLevelResolver;

    IssueSecurityLevelClauseContextFactory(IssueSecurityLevelResolver issueSecurityLevelResolver, JqlOperandResolver jqlOperandResolver, IssueSecuritySchemeManager issueSecuritySchemeManager, ProjectManager projectManager) {
        this.issueSecurityLevelResolver = (IssueSecurityLevelResolver)Assertions.notNull((String)"issueSecurityLevelResolver", (Object)issueSecurityLevelResolver);
        this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
        this.issueSecuritySchemeManager = (IssueSecuritySchemeManager)Assertions.notNull((String)"issueSecuritySchemeManager", (Object)issueSecuritySchemeManager);
        this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
    }

    public ClauseContext getClauseContext(User searcher, TerminalClause terminalClause) {
        Operator operator = terminalClause.getOperator();
        if (!this.isEqualityOperator(operator)) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        return this.getContextFromClause(searcher, terminalClause);
    }

    ClauseContext getContextFromClause(User searcher, TerminalClause terminalClause) {
        Set<Project> associatedProjects = this.getAssociatedProjectsFromClause(searcher, terminalClause);
        if (associatedProjects.isEmpty()) {
            return ClauseContextImpl.createGlobalClauseContext();
        }
        Set<ProjectIssueTypeContext> contexts = this.getContextsForProjects(associatedProjects);
        return contexts.isEmpty() ? ClauseContextImpl.createGlobalClauseContext() : new ClauseContextImpl(contexts);
    }

    Set<Project> getAssociatedProjectsFromClause(User searcher, TerminalClause terminalClause) {
        List<GenericValue> securityLevels = this.getSecurityLevelsFromClause(searcher, terminalClause);
        HashSet<Project> associatedProjects = new HashSet<Project>();
        for (GenericValue securityLevel : securityLevels) {
            if (securityLevel == null) continue;
            associatedProjects.addAll(this.getProjectsForSecurityLevel(securityLevel));
        }
        return associatedProjects;
    }

    List<GenericValue> getSecurityLevelsFromClause(User searcher, TerminalClause terminalClause) {
        List literals = this.jqlOperandResolver.getValues(searcher, terminalClause.getOperand(), terminalClause);
        if (literals == null) {
            return Collections.emptyList();
        }
        List<GenericValue> levels = this.issueSecurityLevelResolver.getIssueSecurityLevels(searcher, literals);
        if (this.isNegationOperator(terminalClause.getOperator()) && CollectionUtil.contains(levels, (Predicate)Predicates.notNull())) {
            List<GenericValue> allLevels = this.issueSecurityLevelResolver.getAllSecurityLevels(searcher);
            allLevels.removeAll(levels);
            return allLevels;
        }
        return levels;
    }

    Collection<Project> getProjectsForSecurityLevel(GenericValue securityLevel) {
        List projectGVs;
        Long schemeId = securityLevel.getLong("scheme");
        try {
            GenericValue scheme = this.issueSecuritySchemeManager.getScheme(schemeId);
            projectGVs = this.issueSecuritySchemeManager.getProjects(scheme);
        }
        catch (GenericEntityException e) {
            log.warn((Object)e, (Throwable)e);
            projectGVs = Collections.emptyList();
        }
        HashSet<Project> projects = new HashSet<Project>();
        for (GenericValue projectGV : projectGVs) {
            projects.add(this.projectManager.getProjectObj(projectGV.getLong("id")));
        }
        return projects;
    }

    private Set<ProjectIssueTypeContext> getContextsForProjects(Collection<Project> projects) {
        CollectionBuilder builder = CollectionBuilder.newBuilder();
        for (Project project : projects) {
            builder.add((Object)new ProjectIssueTypeContextImpl((ProjectContext)new ProjectContextImpl(project.getId()), (IssueTypeContext)AllIssueTypesContext.INSTANCE));
        }
        return builder.asMutableSet();
    }

    private boolean isNegationOperator(Operator operator) {
        return OperatorClasses.NEGATIVE_EQUALITY_OPERATORS.contains(operator);
    }

    private boolean isEqualityOperator(Operator operator) {
        return OperatorClasses.EQUALITY_OPERATORS_WITH_EMPTY.contains(operator);
    }

    @InjectableComponent
    public static class Creator {
        private final JqlOperandResolver jqlOperandResolver;
        private final IssueSecuritySchemeManager issueSecuritySchemeManager;
        private final ProjectManager projectManager;
        private final IssueSecurityLevelResolver issueSecurityLevelResolver;

        public Creator(IssueSecurityLevelResolver issueSecurityLevelResolver, JqlOperandResolver jqlOperandResolver, IssueSecuritySchemeManager issueSecuritySchemeManager, ProjectManager projectManager) {
            this.issueSecurityLevelResolver = (IssueSecurityLevelResolver)Assertions.notNull((String)"issueSecurityLevelResolver", (Object)issueSecurityLevelResolver);
            this.jqlOperandResolver = (JqlOperandResolver)Assertions.notNull((String)"jqlOperandResolver", (Object)jqlOperandResolver);
            this.issueSecuritySchemeManager = (IssueSecuritySchemeManager)Assertions.notNull((String)"issueSecuritySchemeManager", (Object)issueSecuritySchemeManager);
            this.projectManager = (ProjectManager)Assertions.notNull((String)"projectManager", (Object)projectManager);
        }

        public IssueSecurityLevelClauseContextFactory create() {
            return new IssueSecurityLevelClauseContextFactory(this.issueSecurityLevelResolver, this.jqlOperandResolver, this.issueSecuritySchemeManager, this.projectManager);
        }
    }
}

