/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.watchers;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.association.UserAssociationStore;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comparator.UserBestNameComparator;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.issue.watchers.WatcherManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.dbc.Null;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;

public class DefaultWatcherManager
implements WatcherManager {
    private static final Logger log = Logger.getLogger(DefaultWatcherManager.class);
    public static final String ASSOCIATION_TYPE = "WatchIssue";
    private final UserAssociationStore userAssociationStore;
    private final ApplicationProperties applicationProperties;
    private final IssueIndexManager indexManager;
    private final UserUtil userUtil;

    public DefaultWatcherManager(UserAssociationStore userAssociationStore, ApplicationProperties applicationProperties, IssueIndexManager indexManager, UserUtil userUtil) {
        this.userAssociationStore = userAssociationStore;
        this.applicationProperties = applicationProperties;
        this.indexManager = indexManager;
        this.userUtil = userUtil;
    }

    public void startWatching(User user, GenericValue issue) {
        this.updateWatch(true, user, issue);
    }

    public void stopWatching(String username, GenericValue issue) {
        this.updateWatch(false, this.userUtil.getUserObject(username), issue);
    }

    public void stopWatching(User user, Issue issue) {
        this.updateWatch(false, user, issue.getGenericValue());
    }

    public void stopWatching(User user, GenericValue issue) {
        this.updateWatch(false, user, issue);
    }

    public List<String> getCurrentWatcherUsernames(Issue issue) throws DataAccessException {
        return this.userAssociationStore.getUsernamesFromSink(ASSOCIATION_TYPE, issue.getGenericValue());
    }

    public boolean isWatchingEnabled() {
        return this.applicationProperties.getOption("jira.option.watching");
    }

    public boolean isWatching(User user, Issue issue) {
        if (user == null) {
            return false;
        }
        Long watches = issue.getWatches();
        if (watches == null || watches == 0L) {
            return false;
        }
        return this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, issue.getGenericValue());
    }

    public boolean isWatching(User user, GenericValue issue) {
        if (user == null) {
            return false;
        }
        if (issue.getLong("watches") == 0L) {
            return false;
        }
        return this.userAssociationStore.associationExists(ASSOCIATION_TYPE, user, issue);
    }

    public Collection<User> getCurrentWatchList(Issue issue, Locale userLocale) {
        return this.getCurrentWatchList(issue.getGenericValue(), userLocale);
    }

    private List<User> getCurrentWatchList(GenericValue issue, Locale userLocale) {
        List<User> watchers = this.userAssociationStore.getUsersFromSink(ASSOCIATION_TYPE, issue);
        Collections.sort(watchers, new UserBestNameComparator(userLocale));
        return watchers;
    }

    public List<String> getCurrentWatcherUsernames(GenericValue issue) throws DataAccessException {
        return this.userAssociationStore.getUsernamesFromSink(ASSOCIATION_TYPE, issue);
    }

    private boolean updateWatch(boolean addWatch, User user, GenericValue issue) {
        if (this.validateUpdate(user, issue)) {
            try {
                if (addWatch) {
                    if (!this.isWatching(user, issue)) {
                        this.userAssociationStore.createAssociation(ASSOCIATION_TYPE, user, issue);
                        this.adjustWatchCount(issue, 1);
                        return true;
                    }
                } else if (this.isWatching(user, issue)) {
                    this.userAssociationStore.removeAssociation(ASSOCIATION_TYPE, user, issue);
                    this.adjustWatchCount(issue, -1);
                    return true;
                }
            }
            catch (GenericEntityException e) {
                log.error((Object)"Error changing watch association", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    private boolean validateUpdate(User user, GenericValue issue) {
        if (issue == null) {
            log.error((Object)"You must specify an issue.");
            return false;
        }
        if (user == null) {
            log.error((Object)"You must specify a user.");
            return false;
        }
        return true;
    }

    private void adjustWatchCount(GenericValue issue, int adjustValue) throws GenericEntityException {
        Long watches = issue.getLong("watches");
        if (watches == null) {
            watches = 0L;
        }
        if ((watches = Long.valueOf(watches + (long)adjustValue)) < 0L) {
            watches = 0L;
        }
        issue.set("watches", (Object)watches);
        issue.store();
        try {
            this.indexManager.reIndex(issue);
        }
        catch (IndexException e) {
            log.error((Object)("Exception re-indexing issue " + (Object)((Object)e)), (Throwable)e);
        }
    }

    public void removeAllWatchesForUser(User user) {
        Null.not("User", user);
        List<GenericValue> watchedIssues = this.userAssociationStore.getSinksFromUser(ASSOCIATION_TYPE, user, "Issue");
        this.userAssociationStore.removeUserAssociationsFromUser(ASSOCIATION_TYPE, user, "Issue");
        for (GenericValue issue : watchedIssues) {
            this.reindex(issue);
        }
    }

    private void reindex(GenericValue issue) {
        try {
            this.indexManager.reIndex(issue);
        }
        catch (IndexException e) {
            throw new RuntimeException(e);
        }
    }
}

