/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views.util;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.LinkCollection;
import com.atlassian.jira.issue.util.AggregateTimeTrackingBean;
import com.atlassian.jira.issue.util.AggregateTimeTrackingCalculatorFactory;
import com.atlassian.jira.issue.views.util.IssueViewUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraDurationUtils;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.TimeTrackingGraphBean;
import com.atlassian.jira.web.bean.TimeTrackingGraphBeanFactory;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class DefaultIssueViewUtil
implements IssueViewUtil {
    public static final Logger log = Logger.getLogger(DefaultIssueViewUtil.class);
    private final IssueLinkManager issueLinkManager;
    private final FieldLayoutManager fieldLayoutManager;
    private final RendererManager rendererManager;
    private final JiraDurationUtils jiraDurationUtils;
    private final AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory;
    private final TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory;

    public DefaultIssueViewUtil(IssueLinkManager issueLinkManager, FieldLayoutManager fieldLayoutManager, RendererManager rendererManager, JiraDurationUtils jiraDurationUtils, AggregateTimeTrackingCalculatorFactory aggregateTimeTrackingCalculatorFactory, TimeTrackingGraphBeanFactory timeTrackingGraphBeanFactory) {
        this.timeTrackingGraphBeanFactory = (TimeTrackingGraphBeanFactory)Assertions.notNull((String)"timeTrackingGraphBeanFactory", (Object)timeTrackingGraphBeanFactory);
        this.aggregateTimeTrackingCalculatorFactory = (AggregateTimeTrackingCalculatorFactory)Assertions.notNull((String)"aggregateTimeTrackingCalculatorFactory", (Object)aggregateTimeTrackingCalculatorFactory);
        this.issueLinkManager = (IssueLinkManager)Assertions.notNull((String)"issueLinkManager", (Object)issueLinkManager);
        this.fieldLayoutManager = (FieldLayoutManager)Assertions.notNull((String)"fieldLayoutManager", (Object)fieldLayoutManager);
        this.rendererManager = (RendererManager)Assertions.notNull((String)"rendererManager", (Object)rendererManager);
        this.jiraDurationUtils = (JiraDurationUtils)Assertions.notNull((String)"jiraDurationUtils", (Object)jiraDurationUtils);
    }

    @Override
    public String getPrettyDuration(Long v) {
        return this.jiraDurationUtils.getFormattedDuration(v);
    }

    @Override
    public LinkCollection getLinkCollection(Issue issue, User user) {
        return this.issueLinkManager.getLinkCollection(issue, user);
    }

    @Override
    public String getRenderedContent(String fieldName, String value, Issue issue) {
        GenericValue projectGV = issue.getProject();
        IssueType issueTypeObject = issue.getIssueTypeObject();
        if (projectGV != null && issueTypeObject != null) {
            FieldLayout fieldLayout = this.fieldLayoutManager.getFieldLayout(projectGV, issueTypeObject.getId());
            if (fieldLayout != null) {
                FieldLayoutItem fieldLayoutItem = fieldLayout.getFieldLayoutItem(fieldName);
                if (fieldLayoutItem != null) {
                    return this.rendererManager.getRenderedContent(fieldLayoutItem.getRendererType(), value, issue.getIssueRenderContext());
                }
                log.debug((Object)"fieldLayoutItem was null");
            } else {
                log.debug((Object)"fieldLayout was null!");
            }
        } else {
            if (projectGV == null) {
                log.debug((Object)"issue projectGV was null!");
            }
            if (issueTypeObject == null) {
                log.debug((Object)"issueTypeObject was null!");
            }
        }
        return value;
    }

    @Override
    public AggregateTimeTrackingBean createAggregateBean(Issue issue) {
        return this.aggregateTimeTrackingCalculatorFactory.getCalculator(issue).getAggregates(issue);
    }

    @Override
    public TimeTrackingGraphBean createTimeTrackingBean(AggregateTimeTrackingBean bean, I18nHelper helper) {
        return this.timeTrackingGraphBeanFactory.createBean(bean, TimeTrackingGraphBeanFactory.Style.NORMAL, helper);
    }
}

