/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.views;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchProvider;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.views.AbstractSearchRequestIssueTableView;
import com.atlassian.jira.issue.views.util.SearchRequestViewBodyWriterUtil;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.issue.views.util.WordViewUtils;
import com.atlassian.jira.plugin.searchrequestview.RequestHeaders;
import com.atlassian.jira.plugin.searchrequestview.SearchRequestParams;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.component.IssueTableLayoutBean;
import com.atlassian.jira.web.component.IssueTableWebComponent;
import com.atlassian.jira.web.component.IssueTableWriter;
import com.atlassian.jira.web.component.TableLayoutFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.Map;

public abstract class AbstractSearchRequestExcelView
extends AbstractSearchRequestIssueTableView {
    protected final TableLayoutFactory tableLayoutFactory;
    private final SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil;
    protected final DateTimeFormatter dateTimeFormatter;

    protected AbstractSearchRequestExcelView(JiraAuthenticationContext authenticationContext, SearchProvider searchProvider, ApplicationProperties appProperties, TableLayoutFactory tableLayoutFactory, SearchRequestViewBodyWriterUtil searchRequestViewBodyWriterUtil, DateTimeFormatter dateTimeFormatter) {
        super(authenticationContext, searchProvider, appProperties, searchRequestViewBodyWriterUtil);
        this.tableLayoutFactory = tableLayoutFactory;
        this.searchRequestViewBodyWriterUtil = searchRequestViewBodyWriterUtil;
        this.dateTimeFormatter = dateTimeFormatter != null ? dateTimeFormatter.forLoggedInUser().withStyle(DateTimeStyle.COMPLETE) : null;
    }

    @Override
    public void writeSearchResults(SearchRequest searchRequest, SearchRequestParams searchRequestParams, Writer writer) {
        Map<String, Object> params = JiraVelocityUtils.getDefaultVelocityParams(this.authenticationContext);
        IssueTableLayoutBean columnLayout = this.getColumnLayout(searchRequest, this.authenticationContext.getUser());
        params.put("i18n", this.authenticationContext.getI18nHelper());
        params.put("encoding", this.applicationProperties.getEncoding());
        params.put("colCount", columnLayout.getColumns().size());
        VelocityRequestContext velocityRequestContext = (VelocityRequestContext)params.get("requestContext");
        params.put("link", SearchRequestViewUtils.getLink(searchRequest, velocityRequestContext.getBaseUrl(), this.authenticationContext.getLoggedInUser()));
        try {
            long numberOfIssues = this.searchProvider.searchCount(searchRequest.getQuery(), this.authenticationContext.getUser());
            numberOfIssues = Math.min(numberOfIssues, (long)searchRequestParams.getPagerFilter().getMax());
            if (numberOfIssues == 0L) {
                params.put("noissues", Boolean.TRUE);
            }
            params.put("generatedInfo", SearchRequestViewUtils.getGeneratedInfo(this.authenticationContext.getLoggedInUser()));
            params.put("resultsDescription", this.getResultsDescription(numberOfIssues));
            this.addLayoutProperties(params);
            params.put("title", SearchRequestViewUtils.getTitle(searchRequest, this.applicationProperties.getDefaultBackedString("jira.title")));
            writer.write(this.descriptor.getHtml("header", params));
            IssueTableWriter issueTableWriter = new IssueTableWebComponent().getHtmlIssueWriter(writer, columnLayout, null, null);
            this.searchRequestViewBodyWriterUtil.writeTableBody(writer, issueTableWriter, searchRequest, searchRequestParams.getPagerFilter());
            writer.write(this.descriptor.getHtml("footer", params));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SearchException e) {
            e.printStackTrace();
        }
    }

    private String getResultsDescription(long searchResultsSize) {
        return this.authenticationContext.getI18nHelper().getText("navigator.excel.results.displayissues", String.valueOf(searchResultsSize), this.dateTimeFormatter.format(new Date()));
    }

    private void addLayoutProperties(Map<String, Object> map) {
        LookAndFeelBean lookAndFeelBean = LookAndFeelBean.getInstance((ApplicationProperties)this.applicationProperties);
        String topBgColour = lookAndFeelBean.getTopBackgroundColour();
        String jiraLogo = lookAndFeelBean.getLogoUrl();
        String jiraLogoWidth = lookAndFeelBean.getLogoWidth();
        String jiraLogoHeight = lookAndFeelBean.getLogoHeight();
        if (jiraLogo != null && !jiraLogo.startsWith("http://") && !jiraLogo.startsWith("https://")) {
            jiraLogo = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext().getBaseUrl() + jiraLogo;
        }
        map.put("topBgColour", topBgColour);
        map.put("jiraLogo", jiraLogo);
        map.put("jiraLogoWidth", jiraLogoWidth);
        map.put("jiraLogoHeight", jiraLogoHeight);
    }

    @Override
    public void writeHeaders(SearchRequest searchRequest, RequestHeaders requestHeaders, SearchRequestParams searchRequestParams) {
        WordViewUtils.writeGenericNoCacheHeaders(requestHeaders);
        WordViewUtils.writeEncodedAttachmentFilenameHeader(requestHeaders, JiraUrlCodec.encode((String)SearchRequestViewUtils.getTitle(searchRequest, this.applicationProperties.getDefaultBackedString("jira.title"))) + ".xls", searchRequestParams.getUserAgent(), this.applicationProperties.getEncoding());
    }

    protected abstract IssueTableLayoutBean getColumnLayout(SearchRequest var1, User var2);
}

