/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.util;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.JiraException;
import com.atlassian.jira.event.issue.IssueEventDispatcher;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.history.ChangeLogUtils;
import com.atlassian.jira.issue.util.IssueUpdateBean;
import com.atlassian.jira.issue.util.IssueUpdater;
import com.atlassian.jira.transaction.Transaction;
import com.atlassian.jira.transaction.Txn;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;

public class DefaultIssueUpdater
implements IssueUpdater {
    private final DelegatorInterface genericDelegator;

    public DefaultIssueUpdater(DelegatorInterface genericDelegator) {
        this.genericDelegator = genericDelegator;
    }

    public void doUpdate(IssueUpdateBean iub, boolean generateChangeItems) throws JiraException {
        GenericValue changedIssue = iub.getChangedIssue();
        changedIssue.set("updated", (Object)UtilDateTime.nowTimestamp());
        Transaction txn = Txn.begin();
        try {
            this.genericDelegator.storeAll((List)ImmutableList.of((Object)changedIssue));
            GenericValue changeGroup = ChangeLogUtils.createChangeGroup(iub.getUser(), iub.getOriginalIssue(), changedIssue, iub.getChangeItems(), generateChangeItems);
            txn.commit();
            if ((changeGroup != null || iub.getComment() != null) && iub.isDispatchEvent()) {
                IssueFactory issueFactory = ComponentManager.getComponentInstanceOfType(IssueFactory.class);
                IssueEventDispatcher.dispatchEvent(iub.getEventTypeId(), (Issue)issueFactory.getIssue(changedIssue), iub.getUser(), iub.getComment(), iub.getWorklog(), changeGroup, iub.getParams(), iub.isSendMail(), iub.isSubtasksUpdated());
            }
        }
        catch (GenericEntityException e) {
            throw new JiraException((Throwable)e);
        }
        catch (Exception e) {
            throw new JiraException((Throwable)e);
        }
        finally {
            txn.finallyRollbackIfNotCommitted();
        }
    }
}

