/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.transitions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.plugin.webfragment.SimpleLinkFactory;
import com.atlassian.jira.plugin.webfragment.descriptors.SimpleLinkFactoryModuleDescriptor;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.plugin.webfragment.model.SimpleLinkImpl;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.XsrfTokenGenerator;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;

public class TransitionLinkFactory
implements SimpleLinkFactory {
    private static final Logger log = Logger.getLogger(TransitionLinkFactory.class);
    private final WorkflowManager workflowManager;
    private final VelocityRequestContextFactory requestContextFactory;

    public TransitionLinkFactory(WorkflowManager workflowManager, VelocityRequestContextFactory requestContextFactory) {
        this.workflowManager = workflowManager;
        this.requestContextFactory = requestContextFactory;
    }

    public void init(SimpleLinkFactoryModuleDescriptor descriptor) {
    }

    public List<SimpleLink> getLinks(User user, Map<String, Object> params) {
        Issue issue = (Issue)params.get("issue");
        return this.getAvailableActions(user, issue);
    }

    private List<SimpleLink> getAvailableActions(User user, Issue issue) {
        VelocityRequestContext requestContext = this.requestContextFactory.getJiraVelocityRequestContext();
        List<ActionDescriptor> actions = this.loadAvailableActions(user, issue);
        ArrayList<SimpleLink> returnList = new ArrayList<SimpleLink>(actions.size());
        Collections.sort(actions, new Comparator<ActionDescriptor>(){

            @Override
            public int compare(ActionDescriptor o1, ActionDescriptor o2) {
                return TransitionLinkFactory.this.getSequenceFromAction(o1).compareTo(TransitionLinkFactory.this.getSequenceFromAction(o2));
            }
        });
        for (ActionDescriptor action : actions) {
            String url = requestContext.getBaseUrl() + "/secure/WorkflowUIDispatcher.jspa?" + "id=" + issue.getId() + "" + "&action=" + action.getId() + "&atl_token=" + this.getXsrfToken();
            String transitionDisplayName = this.getWorkflowTransitionDisplayName(action);
            String description = this.getWorkflowTransitionDescription(action);
            returnList.add(new SimpleLinkImpl("action_id_" + action.getId(), transitionDisplayName, StringUtils.isBlank((String)description) ? null : transitionDisplayName + " - " + description, null, "issueaction-workflow-transition", null, url, null));
        }
        return returnList;
    }

    private Integer getSequenceFromAction(ActionDescriptor action) {
        if (action == null) {
            return Integer.MAX_VALUE;
        }
        Map metaAttributes = action.getMetaAttributes();
        if (metaAttributes == null) {
            return Integer.MAX_VALUE;
        }
        String value = (String)metaAttributes.get("opsbar-sequence");
        if (value == null || StringUtils.isBlank((String)value) || !StringUtils.isNumeric((String)value)) {
            return Integer.MAX_VALUE;
        }
        return Integer.valueOf(value);
    }

    private List<ActionDescriptor> loadAvailableActions(User user, Issue issueObject) {
        Project project = issueObject.getProjectObject();
        ArrayList<ActionDescriptor> availableActions = new ArrayList<ActionDescriptor>();
        if (issueObject.getWorkflowId() == null) {
            log.warn((Object)("!!! Issue " + issueObject.getKey() + " has no workflow ID !!! "));
            return availableActions;
        }
        try {
            int[] actionIds;
            Workflow wf = this.workflowManager.makeWorkflow(user != null ? user.getName() : null);
            WorkflowDescriptor wd = this.workflowManager.getWorkflow(issueObject).getDescriptor();
            HashMap<String, String> inputs = new HashMap<String, String>();
            inputs.put("pkey", project.getKey());
            inputs.put("issue", (String)issueObject);
            inputs.put("originalissueobject", (String)issueObject);
            for (int actionId : actionIds = wf.getAvailableActions(issueObject.getWorkflowId().longValue(), inputs)) {
                ActionDescriptor action = wd.getAction(actionId);
                if (action == null) {
                    log.error((Object)("State of issue [" + issueObject + "] has an action [id=" + actionId + "] which cannot be found in the workflow descriptor"));
                    continue;
                }
                availableActions.add(action);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception thrown while gettig avilable actions", (Throwable)e);
        }
        return availableActions;
    }

    String getWorkflowTransitionDisplayName(ActionDescriptor descriptor) {
        return WorkflowUtil.getWorkflowTransitionDisplayName((ActionDescriptor)descriptor);
    }

    String getWorkflowTransitionDescription(ActionDescriptor descriptor) {
        return StringUtils.trimToNull((String)WorkflowUtil.getWorkflowTransitionDescription((ActionDescriptor)descriptor));
    }

    String getXsrfToken() {
        HttpServletRequest request = ActionContext.getRequest();
        if (request != null) {
            return this.getXsrfTokenGenerator().generateToken(request);
        }
        return "";
    }

    XsrfTokenGenerator getXsrfTokenGenerator() {
        return ComponentManager.getComponentInstanceOfType(XsrfTokenGenerator.class);
    }
}

