/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.tabpanels;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.plugin.issuetabpanel.AbstractIssueAction;
import com.atlassian.jira.plugin.issuetabpanel.IssueTabPanelModuleDescriptor;
import com.atlassian.jira.user.UserUtils;
import com.atlassian.jira.vcs.cvsimpl.CVSCommit;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class CVSAction
extends AbstractIssueAction {
    private CVSCommit commit;
    private User user;

    public CVSAction(IssueTabPanelModuleDescriptor descriptor, CVSCommit commit) {
        super(descriptor);
        this.commit = commit;
    }

    public Date getTimePerformed() {
        return this.commit.getTimePerformed();
    }

    protected void populateVelocityParams(Map params) {
        params.put("cvsCommit", this);
    }

    public String getUsername() {
        return this.commit.getUsername();
    }

    public User getUser() {
        if (this.user == null) {
            this.user = UserUtils.getUser((String)this.commit.getUsername());
        }
        return this.user;
    }

    public String getFullName() {
        if (this.getUser() != null) {
            return this.getUser().getDisplayName();
        }
        return null;
    }

    public String getComment() {
        return this.commit.getComment();
    }

    public Collection getRevisions() {
        return this.commit.getRevisions();
    }

    public String getRepositoryName() {
        return this.commit.getRepositoryName();
    }

    public String getBranchName() {
        return this.commit.getBranchName();
    }

    public boolean hasRepositoryViewer() {
        return this.commit.hasRepositoryViewer();
    }

    public String getFileLink(String filePath) {
        return this.commit.getFileLink(filePath);
    }

    public String getRevisionLink(String filePath, String revision) {
        return this.commit.getRevisionLink(filePath, revision);
    }

    public String getDiffLink(String filePath, String revision) {
        return this.commit.getDiffLink(filePath, revision);
    }
}

