/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.statistics;

import com.atlassian.jira.issue.customfields.statistics.CustomFieldStattable;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.statistics.FilterStatisticsValuesGenerator;
import com.opensymphony.util.TextUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.ListOrderedMap;
import org.ofbiz.core.entity.GenericValue;

public class FilterStatisticsCascadingSelectValuesGenerator
extends FilterStatisticsValuesGenerator {
    public Map getValues(Map params) {
        ListOrderedMap allValues = new ListOrderedMap();
        allValues.putAll(this.getValueClassHolderSystemValues());
        List customFieldObjects = this.customFieldManager.getCustomFieldObjects();
        for (CustomField customField : customFieldObjects) {
            if (!(customField.getCustomFieldSearcher() instanceof CustomFieldStattable)) continue;
            allValues.put(customField.getId(), this.getValueClassHolderForCF(customField));
        }
        return allValues;
    }

    private ValueClassHolder getValueClassHolderForCF(CustomField customField) {
        StringBuffer className = new StringBuffer();
        int i = 0;
        Iterator iterator = customField.getAssociatedProjects().iterator();
        while (iterator.hasNext()) {
            if (i != 0) {
                className.append(":");
            }
            GenericValue project = (GenericValue)iterator.next();
            className.append(project.getString("id"));
            ++i;
        }
        if (!TextUtils.stringSet((String)className.toString())) {
            return new ValueClassHolder(customField.getName(), "select");
        }
        return new ValueClassHolder(customField.getName(), className.toString());
    }

    private Map getValueClassHolderSystemValues() {
        HashMap<String, ValueClassHolder> valueClassSystemValue = new HashMap<String, ValueClassHolder>();
        for (String key : systemValues.keySet()) {
            valueClassSystemValue.put(key, new ValueClassHolder((String)systemValues.get(key), "select"));
        }
        return valueClassSystemValue;
    }

    private static class ValueClassHolder {
        private String value;
        private String className;

        public ValueClassHolder(String value, String className) {
            this.value = value;
            this.className = className;
        }

        public String getValue() {
            return this.value;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.value;
        }
    }
}

