/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search.searchers.renderer;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ManagerFactory;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserPickerSearchService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstants;
import com.atlassian.jira.issue.search.constants.UserFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.searchers.renderer.AbstractSearchRenderer;
import com.atlassian.jira.issue.search.searchers.renderer.SearchRenderer;
import com.atlassian.jira.issue.transport.FieldValuesHolder;
import com.atlassian.jira.security.Permissions;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.query.Query;
import com.atlassian.velocity.VelocityManager;
import java.util.List;
import java.util.Map;
import webwork.action.Action;

public abstract class AbstractUserSearchRenderer
extends AbstractSearchRenderer
implements SearchRenderer {
    public static final String SELECT_LIST_NONE = "select.list.none";
    public static final String SELECT_LIST_USER = "select.list.user";
    public static final String SELECT_LIST_GROUP = "select.list.group";
    private final UserFieldSearchConstants searchConstants;
    private final String emptySelectFlag;
    private final String nameKey;
    private final ApplicationProperties applicationProperties;
    private final UserPickerSearchService searchService;

    public AbstractUserSearchRenderer(UserFieldSearchConstantsWithEmpty searchConstants, String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, UserPickerSearchService searchService) {
        super(velocityRequestContextFactory, applicationProperties, velocityManager, searchConstants.getSearcherId(), nameKey);
        this.emptySelectFlag = searchConstants.getEmptySelectFlag();
        this.searchConstants = searchConstants;
        this.nameKey = nameKey;
        this.applicationProperties = applicationProperties;
        this.searchService = searchService;
    }

    public AbstractUserSearchRenderer(UserFieldSearchConstants searchConstants, String nameKey, VelocityRequestContextFactory velocityRequestContextFactory, ApplicationProperties applicationProperties, VelocityManager velocityManager, UserPickerSearchService searchService) {
        super(velocityRequestContextFactory, applicationProperties, velocityManager, searchConstants.getSearcherId(), nameKey);
        this.emptySelectFlag = null;
        this.searchConstants = searchConstants;
        this.nameKey = nameKey;
        this.applicationProperties = applicationProperties;
        this.searchService = searchService;
    }

    public String getEditHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        int permissionId = Permissions.getType((String)"pickusers");
        boolean pickPermission = ManagerFactory.getPermissionManager().hasPermission(permissionId, searcher);
        velocityParams.put("hasPermissionToPickUsers", pickPermission);
        velocityParams.put("selectListOptions", this.getSelectedListOptions(searcher));
        return this.renderEditTemplate("user-searcher-edit.vm", velocityParams);
    }

    public String getViewHtml(User searcher, SearchContext searchContext, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map<String, Object> velocityParams = this.getVelocityParams(searcher, searchContext, null, fieldValuesHolder, displayParameters, action);
        velocityParams.put("textForuser", this.getTextForuser(searcher, fieldValuesHolder));
        velocityParams.put("linkedGroup", this.getLinkedGroup(searcher, fieldValuesHolder));
        velocityParams.put("linkedUser", this.getLinkedUser(searcher, fieldValuesHolder));
        return this.renderViewTemplate("user-searcher-view.vm", velocityParams);
    }

    public boolean isRelevantForQuery(User searcher, Query query) {
        return this.isRelevantForQuery(this.searchConstants.getJqlClauseNames(), query);
    }

    protected abstract List<Map<String, String>> getSelectedListOptions(User var1);

    protected abstract String getEmptyValueKey();

    protected String getTextForuser(User searcher, FieldValuesHolder fieldValuesHolder) {
        String selectList = (String)fieldValuesHolder.get((Object)this.searchConstants.getSelectUrlParameter());
        if (this.emptySelectFlag != null && this.emptySelectFlag.equals(selectList)) {
            return this.getI18n(searcher).getText(this.getEmptyValueKey());
        }
        if (this.searchConstants.getCurrentUserSelectFlag().equals(selectList)) {
            return this.getI18n(searcher).getText("reporter.types.currentuser");
        }
        return (String)fieldValuesHolder.get((Object)this.searchConstants.getFieldUrlParameter());
    }

    private String getLinkedUser(User searcher, FieldValuesHolder fieldValuesHolder) {
        String selectList = (String)fieldValuesHolder.get((Object)this.searchConstants.getSelectUrlParameter());
        if (this.searchConstants.getCurrentUserSelectFlag().equals(selectList)) {
            if (searcher != null) {
                return searcher.getName();
            }
        } else if (this.searchConstants.getSpecificUserSelectFlag().equals(selectList)) {
            return (String)fieldValuesHolder.get((Object)this.searchConstants.getFieldUrlParameter());
        }
        return null;
    }

    private String getLinkedGroup(User searcher, FieldValuesHolder fieldValuesHolder) {
        String selectList = (String)fieldValuesHolder.get((Object)this.searchConstants.getSelectUrlParameter());
        if (this.searchConstants.getSpecificGroupSelectFlag().equals(selectList) && ManagerFactory.getPermissionManager().hasPermission(0, searcher)) {
            return (String)fieldValuesHolder.get((Object)this.searchConstants.getFieldUrlParameter());
        }
        return null;
    }

    protected Map<String, Object> getVelocityParams(User searcher, SearchContext searchContext, FieldLayoutItem fieldLayoutItem, FieldValuesHolder fieldValuesHolder, Map displayParameters, Action action) {
        Map velocityParams = super.getVelocityParams(searcher, searchContext, fieldLayoutItem, fieldValuesHolder, displayParameters, action);
        JiraServiceContextImpl ctx = new JiraServiceContextImpl(searcher);
        boolean canPerformAjaxSearch = this.searchService.canPerformAjaxSearch((JiraServiceContext)ctx);
        velocityParams.put("name", this.getI18n(searcher).getText(this.nameKey));
        velocityParams.put("userField", this.searchConstants.getFieldUrlParameter());
        velocityParams.put("userSelect", this.searchConstants.getSelectUrlParameter());
        WebResourceManager webResourceManager = ComponentAccessor.getWebResourceManager();
        webResourceManager.requireResource("jira.webresources:autocomplete");
        if (canPerformAjaxSearch) {
            velocityParams.put("canPerformAjaxSearch", "true");
            velocityParams.put("ajaxLimit", this.applicationProperties.getDefaultBackedString("jira.ajax.autocomplete.limit"));
        }
        return velocityParams;
    }
}

