/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.ChangedClause;
import com.atlassian.query.clause.ChangedClauseImpl;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.ClauseVisitor;
import com.atlassian.query.clause.NotClause;
import com.atlassian.query.clause.OrClause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.clause.WasClause;
import com.atlassian.query.clause.WasClauseImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ClauseRenamingCloningVisitor
implements ClauseVisitor<Clause> {
    private final Map<String, String> lowerCaseSubstitutions;

    public ClauseRenamingCloningVisitor(Map<String, String> substitutions) {
        Assertions.notNull((String)"substitutions", substitutions);
        this.lowerCaseSubstitutions = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : substitutions.entrySet()) {
            this.lowerCaseSubstitutions.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    public Clause visit(AndClause andClause) {
        ArrayList<Object> subClauses = new ArrayList<Object>();
        for (Clause clause : andClause.getClauses()) {
            subClauses.add(clause.accept((ClauseVisitor)this));
        }
        return new AndClause(subClauses);
    }

    public Clause visit(NotClause notClause) {
        Clause newSubClause = (Clause)notClause.getSubClause().accept((ClauseVisitor)this);
        return new NotClause(newSubClause);
    }

    public Clause visit(OrClause orClause) {
        ArrayList<Object> subClauses = new ArrayList<Object>();
        for (Clause clause : orClause.getClauses()) {
            subClauses.add(clause.accept((ClauseVisitor)this));
        }
        return new OrClause(subClauses);
    }

    public Clause visit(TerminalClause clause) {
        String lowerCaseName = clause.getName().toLowerCase();
        if (this.lowerCaseSubstitutions.containsKey(lowerCaseName)) {
            return new TerminalClauseImpl(this.lowerCaseSubstitutions.get(lowerCaseName), clause.getOperator(), clause.getOperand());
        }
        return clause;
    }

    public Clause visit(WasClause clause) {
        return new WasClauseImpl(clause);
    }

    public Clause visit(ChangedClause clause) {
        return new ChangedClauseImpl(clause);
    }
}

