/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.pager;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.pager.NextPreviousPager;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.web.session.SessionNextPreviousPagerManager;
import com.atlassian.jira.web.session.SessionSearchObjectManagerFactory;
import org.apache.log4j.Logger;

public class PagerManager {
    private static final Logger log = Logger.getLogger(PagerManager.class);
    private final ApplicationProperties applicationProperties;
    private final SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory;

    public PagerManager(ApplicationProperties applicationProperties, SessionSearchObjectManagerFactory sessionSearchObjectManagerFactory) {
        this.applicationProperties = applicationProperties;
        this.sessionSearchObjectManagerFactory = sessionSearchObjectManagerFactory;
    }

    public void updatePager(NextPreviousPager pager, SearchRequest searchRequest, User user, String currentKey) {
        if (searchRequest == null) {
            return;
        }
        try {
            pager.update(searchRequest, user, currentKey);
        }
        catch (SearchException e) {
            log.debug((Object)("Error getting keys for next/previous pager " + e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)("Error getting keys for next/previous pager " + e.getMessage()), (Throwable)e);
        }
    }

    public NextPreviousPager getPager() {
        SessionNextPreviousPagerManager sessionSearchRequestManager = this.sessionSearchObjectManagerFactory.createNextPreviousPagerManager();
        NextPreviousPager currentNextPreviousPager = (NextPreviousPager)sessionSearchRequestManager.getCurrentObject();
        if (currentNextPreviousPager == null) {
            currentNextPreviousPager = new NextPreviousPager(this.applicationProperties);
            sessionSearchRequestManager.setCurrentObject(currentNextPreviousPager);
        }
        return currentNextPreviousPager;
    }

    public void clearPager() {
        SessionNextPreviousPagerManager sessionSearchRequestManager = this.sessionSearchObjectManagerFactory.createNextPreviousPagerManager();
        sessionSearchRequestManager.setCurrentObject(null);
    }
}

