/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.managers;

import com.atlassian.core.ofbiz.util.EntityUtils;
import com.atlassian.core.ofbiz.util.OFBizPropertyUtils;
import com.atlassian.core.util.WebRequestUtils;
import com.atlassian.core.util.collection.EasyList;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.TemporaryAttachment;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.ComponentLocator;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.CollectionBuilder;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.util.UtilDateTime;
import webwork.action.ServletActionContext;

public class DefaultAttachmentManager
implements AttachmentManager {
    private static final Logger log = Logger.getLogger(DefaultAttachmentManager.class);
    private final IssueManager issueManager;
    private final OfBizDelegator ofBizDelegator;
    private final MimeManager mimeManager;
    private final ApplicationProperties applicationProperties;
    private final AttachmentPathManager attachmentPathManager;
    private final ComponentLocator componentLocator;
    private final I18nHelper.BeanFactory i18nBeanFactory;

    public DefaultAttachmentManager(IssueManager issueManager, OfBizDelegator ofBizDelegator, MimeManager mimeManager, ApplicationProperties applicationProperties, AttachmentPathManager attachmentPathManager, ComponentLocator componentLocator, I18nHelper.BeanFactory i18nBeanFactory) {
        this.issueManager = issueManager;
        this.ofBizDelegator = ofBizDelegator;
        this.mimeManager = mimeManager;
        this.applicationProperties = applicationProperties;
        this.attachmentPathManager = attachmentPathManager;
        this.componentLocator = componentLocator;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    public Attachment getAttachment(Long id) {
        GenericValue attachmentGV;
        try {
            attachmentGV = this.ofBizDelegator.findByPrimaryKey("FileAttachment", MapBuilder.build((Object)"id", (Object)id));
        }
        catch (DataAccessException e) {
            log.error((Object)("Unable to find a file attachment with id: " + id));
            throw e;
        }
        if (attachmentGV == null) {
            throw new AttachmentNotFoundException((Object)id);
        }
        return new Attachment(this.issueManager, attachmentGV, OFBizPropertyUtils.getPropertySet(attachmentGV));
    }

    public List<Attachment> getAttachments(Issue issue) {
        return this.getStoredAttachments(issue);
    }

    public List<Attachment> getStoredAttachments(Issue issue) {
        try {
            GenericValue issueGV = issue.getGenericValue();
            List attachmentGvs = issueGV.getRelatedOrderBy("ChildFileAttachment", EasyList.build((Object)"filename ASC", (Object)"created DESC"));
            ArrayList<Attachment> attachments = new ArrayList<Attachment>(attachmentGvs.size());
            for (GenericValue attachmentGV : attachmentGvs) {
                attachments.add(new Attachment(this.issueManager, attachmentGV, OFBizPropertyUtils.getPropertySet(attachmentGV)));
            }
            return attachments;
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
    }

    private List<Attachment> getStoredAttachments(Issue issue, Comparator<? super Attachment> comparator) {
        List<Attachment> attachments = this.getStoredAttachments(issue);
        Collections.sort(attachments, comparator);
        return attachments;
    }

    public List<Attachment> getAttachments(Issue issue, Comparator<? super Attachment> comparator) {
        return this.getStoredAttachments(issue, comparator);
    }

    public Attachment createAttachmentCopySourceFile(File file, String filename, String contentType, String attachmentAuthor, Issue issue, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException {
        Attachment attachment;
        if (file == null) {
            log.warn((Object)("Cannot create attachment without a file (filename=" + filename + ")."));
            return null;
        }
        if (filename == null) {
            log.warn((Object)("Cannot create attachment without a filename - inline content? See http://jira.atlassian.com/browse/JRA-10825 (file=" + file.getName() + ")."));
            return null;
        }
        AttachmentUtils.checkValidAttachmentDirectory((Issue)issue);
        String contentTypeFromFile = this.mimeManager.getSanitisedMimeType(contentType, filename);
        try {
            attachment = this.createAttachment(issue.getId(), attachmentAuthor, contentTypeFromFile, filename, (Long)file.length(), attachmentProperties, createdTime);
        }
        catch (GenericEntityException e) {
            throw new DataAccessException((Throwable)e);
        }
        this.createAttachmentOnDiskCopySourceFile(attachment, file);
        return attachment;
    }

    public Attachment createAttachment(GenericValue issue, User author, String mimetype, String filename, Long filesize, Map<String, Object> attachmentProperties, Date createdTime) throws GenericEntityException {
        return this.createAttachment(issue.getLong("id"), author != null ? author.getName() : null, mimetype, filename, filesize, attachmentProperties, createdTime);
    }

    private Attachment createAttachment(Long issueId, String authorName, String mimetype, String filename, Long filesize, Map<String, Object> attachmentProperties, Date createdTime) throws GenericEntityException {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("issue", issueId);
        fields.put("author", authorName);
        fields.put("mimetype", mimetype);
        fields.put("filename", filename);
        fields.put("filesize", filesize);
        fields.put("created", createdTime);
        GenericValue attachmentGV = EntityUtils.createValue("FileAttachment", fields);
        if (attachmentProperties != null) {
            PropertySet propSet = this.createAttachmentPropertySet(attachmentGV, attachmentProperties);
            return new Attachment(this.issueManager, attachmentGV, propSet);
        }
        return new Attachment(this.issueManager, attachmentGV);
    }

    public void deleteAttachment(Attachment attachment) throws RemoveException {
        try {
            if (!DefaultAttachmentManager.deleteAttachmentFile(attachment)) {
                throw new RemoveException("Could not delete attachment file");
            }
            this.ofBizDelegator.removeAll(CollectionBuilder.list((Object[])new GenericValue[]{attachment.getGenericValue()}));
        }
        catch (GenericEntityException e) {
            log.error((Object)"Unable to delete attachment.", (Throwable)e);
            throw new DataAccessException((Throwable)e);
        }
    }

    public void deleteAttachmentDirectory(Issue issue) throws RemoveException {
        this.deleteAttachmentDirectory(issue.getGenericValue());
    }

    IssueFactory getIssueFactory() {
        return (IssueFactory)this.componentLocator.getComponent(IssueFactory.class);
    }

    private void deleteAttachmentDirectory(GenericValue issue) throws RemoveException {
        if (issue != null && this.attachmentsAllowedAndDirectoryIsSet()) {
            File attachmentDir = AttachmentUtils.getAttachmentDirectory((Issue)this.getIssueFactory().getIssue(issue));
            if (!attachmentDir.isDirectory()) {
                throw new RemoveException("Attachment path '" + attachmentDir + "' is not a directory");
            }
            if (!attachmentDir.canWrite()) {
                throw new RemoveException("Can't write to attachment directory '" + attachmentDir + "'");
            }
            File thumbnailDirectory = new File(attachmentDir, "thumbs");
            if (thumbnailDirectory.exists()) {
                if (thumbnailDirectory.listFiles().length == 0) {
                    boolean deleted = thumbnailDirectory.delete();
                    if (!deleted) {
                        log.error((Object)("Unable to delete the issue attachment thumbnail directory '" + thumbnailDirectory + "'."));
                    }
                } else {
                    for (File file : thumbnailDirectory.listFiles()) {
                        System.out.println("file = " + file);
                    }
                    log.error((Object)("Unable to delete the issue attachment thumbnail directory '" + thumbnailDirectory + "' because it is not empty."));
                }
            }
            if (attachmentDir.listFiles().length == 0) {
                if (!attachmentDir.delete()) {
                    log.error((Object)("Unable to delete the issue attachment directory '" + attachmentDir + "'."));
                }
            } else {
                log.error((Object)("Unable to delete the issue attachment directory '" + attachmentDir + "' because it is not empty."));
            }
        }
    }

    private boolean attachmentsAllowedAndDirectoryIsSet() {
        String attachmentDir = this.attachmentPathManager.getAttachmentPath();
        return this.applicationProperties.getOption("jira.option.allowattachments") && StringUtils.isNotBlank((String)attachmentDir);
    }

    public boolean attachmentsEnabled() {
        boolean allowAttachments = this.applicationProperties.getOption("jira.option.allowattachments");
        boolean attachmentPathSet = StringUtils.isNotBlank((String)this.attachmentPathManager.getAttachmentPath());
        return allowAttachments && attachmentPathSet;
    }

    public boolean isScreenshotAppletEnabled() {
        return this.applicationProperties.getOption("jira.screenshotapplet.enabled");
    }

    protected boolean isScreenshotAppletEnabledForLinux() {
        return this.applicationProperties.getOption("jira.screenshotapplet.linux.enabled");
    }

    public boolean isScreenshotAppletSupportedByOS() {
        if (this.isScreenshotAppletEnabledForLinux()) {
            return true;
        }
        int browserOS = this.getUsersOS();
        return browserOS == 10 || browserOS == 20;
    }

    public List<ChangeItemBean> convertTemporaryAttachments(User user, Issue issue, List<Long> selectedAttachments, TemporaryAttachmentsMonitor temporaryAttachmentsMonitor) throws AttachmentException, GenericEntityException {
        Assertions.notNull((String)"issue", (Object)issue);
        Assertions.notNull((String)"selectedAttachments", selectedAttachments);
        Assertions.notNull((String)"temporaryAttachmentsMonitor", (Object)temporaryAttachmentsMonitor);
        ArrayList<ChangeItemBean> ret = new ArrayList<ChangeItemBean>();
        for (Long selectedAttachment : selectedAttachments) {
            TemporaryAttachment tempAttachment = temporaryAttachmentsMonitor.getById(selectedAttachment);
            ChangeItemBean cib = this.createAttachment(tempAttachment.getFile(), tempAttachment.getFilename(), tempAttachment.getContentType(), user, issue.getGenericValue(), Collections.<String, Object>emptyMap(), (Date)UtilDateTime.nowTimestamp());
            if (cib == null) continue;
            ret.add(cib);
        }
        temporaryAttachmentsMonitor.clearEntriesForIssue(issue.getId());
        return ret;
    }

    int getUsersOS() {
        HttpServletRequest servletRequest = ExecutingHttpRequest.get();
        if (servletRequest == null) {
            servletRequest = ServletActionContext.getRequest();
        }
        return WebRequestUtils.getBrowserOperationSystem(servletRequest);
    }

    private static boolean deleteAttachmentFile(Attachment attachment) throws GenericEntityException {
        File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)attachment);
        File thumbnailFile = AttachmentUtils.getThumbnailFile((Attachment)attachment);
        FileUtils.deleteQuietly((File)AttachmentUtils.getLegacyThumbnailFile((Attachment)attachment));
        if (attachmentFile.exists() && thumbnailFile.exists()) {
            return attachmentFile.delete() && thumbnailFile.delete();
        }
        if (attachmentFile.exists()) {
            return attachmentFile.delete();
        }
        log.warn((Object)("Trying to delete non-existent attachment: [" + attachmentFile.getAbsolutePath() + "] ..ignoring"));
        return true;
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, User remoteUser, GenericValue issue, Map<String, Object> attachmentProperties, Date createdTime) throws AttachmentException, GenericEntityException {
        if (file == null) {
            log.warn((Object)("Cannot create attachment without a file (filename=" + filename + ")."));
            return null;
        }
        if (filename == null) {
            log.warn((Object)("Cannot create attachment without a filename - inline content? See http://jira.atlassian.com/browse/JRA-10825 (file=" + file.getName() + ")."));
            return null;
        }
        AttachmentUtils.checkValidAttachmentDirectory((Issue)this.getIssueFactory().getIssue(issue));
        contentType = this.mimeManager.getSanitisedMimeType(contentType, filename);
        Attachment attachment = this.createAttachment(issue, remoteUser, contentType, filename, new Long(file.length()), attachmentProperties, createdTime);
        this.createAttachmentOnDisk(attachment, file, remoteUser);
        return new ChangeItemBean("jira", "Attachment", null, null, attachment.getId().toString(), filename);
    }

    public ChangeItemBean createAttachment(File file, String filename, String contentType, User remoteUser, GenericValue issue) throws AttachmentException, GenericEntityException {
        return this.createAttachment(file, filename, contentType, remoteUser, issue, Collections.<String, Object>emptyMap(), (Date)UtilDateTime.nowTimestamp());
    }

    protected void createAttachmentOnDisk(Attachment attachment, File file, User user) throws AttachmentException {
        File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)attachment);
        boolean renameSucceded = file.renameTo(attachmentFile);
        if (!renameSucceded) {
            try {
                com.atlassian.core.util.FileUtils.copyFile((File)file, (File)attachmentFile);
                if (!file.delete()) {
                    throw new AttachmentException(this.i18nBeanFactory.getInstance(user).getText("attachfile.error.delete", file.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                String message = this.i18nBeanFactory.getInstance(user).getText("attachfile.error.move", (Object)EasyList.build((Object)file.getAbsolutePath(), (Object)attachmentFile.getAbsolutePath(), (Object)e));
                log.error((Object)message, (Throwable)e);
                throw new AttachmentException(message);
            }
        }
    }

    protected void createAttachmentOnDiskCopySourceFile(Attachment attachment, File file) throws AttachmentException {
        File attachmentFile = AttachmentUtils.getAttachmentFile((Attachment)attachment);
        try {
            com.atlassian.core.util.FileUtils.copyFile((File)file, (File)attachmentFile);
        }
        catch (IOException e) {
            log.error((Object)("Could not copy attachment from '" + file.getAbsolutePath() + "' to '" + attachmentFile.getAbsolutePath() + "'."), (Throwable)e);
            throw new AttachmentException("Could not copy attachment from '" + file.getAbsolutePath() + "' to '" + attachmentFile.getAbsolutePath() + "'.");
        }
    }

    private PropertySet createAttachmentPropertySet(GenericValue attachment, Map<String, Object> attachmentProperties) {
        PropertySet propSet = OFBizPropertyUtils.getPropertySet(attachment);
        for (Map.Entry<String, Object> entry : attachmentProperties.entrySet()) {
            propSet.setAsActualType(entry.getKey(), entry.getValue());
        }
        return propSet;
    }
}

