/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.link;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.link.RemoteJiraGlobalIdFactory;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.json.JSONTokener;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import java.net.URI;
import org.apache.commons.lang.StringUtils;

public class RemoteJiraRestHelper {
    private static final String JSON_CONTENT_TYPE = "application/json";
    private static final String REST_BASE_URL = "rest/api/";
    private static final String ISSUE_RESOURCE = "issue";
    private static final String REMOTE_LINK_RESOURCE = "remotelink";
    private final InternalHostApplication internalHostApplication;

    public RemoteJiraRestHelper(InternalHostApplication internalHostApplication) {
        this.internalHostApplication = internalHostApplication;
    }

    public static RestResponse getIssueResponse(ApplicationLink applicationLink, String issueKey, String restVersion) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = RemoteJiraRestHelper.createGetIssueRequest(applicationLink, issueKey, restVersion);
        return (RestResponse)request.executeAndReturn((ReturningResponseHandler)new RestResponseHandler());
    }

    public RestResponse createRemoteIssueLink(ApplicationLink applicationLink, String remoteIssueKey, Issue issue, String relationship, String restVersion) throws CredentialsRequiredException, ResponseException {
        ApplicationLinkRequest request = RemoteJiraRestHelper.createCreateRemoteIssueLinkRequest(applicationLink, remoteIssueKey, restVersion);
        request.setRequestContentType(JSON_CONTENT_TYPE);
        request.setRequestBody(this.getJsonForCreateRemoteIssueLink(issue, relationship));
        return (RestResponse)request.executeAndReturn((ReturningResponseHandler)new RestResponseHandler());
    }

    public static String buildIssueUrl(URI baseUri, String issueKey) {
        return new UrlBuilder(baseUri.toASCIIString()).addPath("browse").addPath(issueKey).asUrlString();
    }

    private String getJsonForCreateRemoteIssueLink(Issue issue, String relationship) {
        try {
            JSONObject json = new JSONObject();
            String globalId = RemoteJiraGlobalIdFactory.encode(this.internalHostApplication.getId(), issue.getId());
            json.put("globalId", (Object)globalId);
            JSONObject application = new JSONObject();
            application.put("type", (Object)"com.atlassian.jira");
            application.put("name", (Object)this.internalHostApplication.getName());
            json.put("application", (Object)application);
            json.put("relationship", (Object)relationship);
            JSONObject object = new JSONObject();
            object.put("url", (Object)RemoteJiraRestHelper.buildIssueUrl(this.internalHostApplication.getBaseUrl(), issue.getKey()));
            object.put("title", (Object)issue.getKey());
            json.put("object", (Object)object);
            return json.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    private static ApplicationLinkRequest createGetIssueRequest(ApplicationLink applicationLink, String issueKey, String restVersion) throws CredentialsRequiredException {
        String restUrl = REST_BASE_URL + restVersion + "/" + ISSUE_RESOURCE + "/" + issueKey;
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        return requestFactory.createRequest(Request.MethodType.GET, restUrl);
    }

    private static ApplicationLinkRequest createCreateRemoteIssueLinkRequest(ApplicationLink applicationLink, String issueKey, String restVersion) throws CredentialsRequiredException {
        String restUrl = REST_BASE_URL + restVersion + "/" + ISSUE_RESOURCE + "/" + issueKey + "/" + REMOTE_LINK_RESOURCE;
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        return requestFactory.createRequest(Request.MethodType.POST, restUrl);
    }

    public static class RestResponse {
        private final JSONObject jsonObject;
        private final int statusCode;
        private final String statusText;
        private final boolean successful;

        public RestResponse(JSONObject jsonObject, int statusCode, String statusText, boolean successful) {
            this.jsonObject = jsonObject;
            this.statusCode = statusCode;
            this.statusText = statusText;
            this.successful = successful;
        }

        public JSONObject getJsonObject() {
            return this.jsonObject;
        }

        public int getStatusCode() {
            return this.statusCode;
        }

        public String getStatusText() {
            return this.statusText;
        }

        public boolean isSuccessful() {
            return this.successful;
        }
    }

    private static class RestResponseHandler
    implements ReturningResponseHandler<Response, RestResponse> {
        private RestResponseHandler() {
        }

        public RestResponse handle(Response response) throws ResponseException {
            JSONObject json;
            String responseString = response.getResponseBodyAsString();
            boolean isBlank = StringUtils.isBlank((String)responseString);
            try {
                json = isBlank ? null : new JSONObject(new JSONTokener(responseString));
            }
            catch (JSONException e) {
                json = null;
            }
            return new RestResponse(json, response.getStatusCode(), response.getStatusText(), response.isSuccessful());
        }
    }
}

